/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.io;

import com.suncode.pwfl.cache.TempFileStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DownloadResource {
    private String fileName;
    private long size;
    private Resource resource;

    public DownloadResource(File file) {
        this(file.getName(), file.length(), (Resource)new FileSystemResource(file));
    }

    public DownloadResource(String fileName, long size, InputStream inputStream) {
        this(fileName, size, (Resource)new InputStreamResource(inputStream));
    }

    public DownloadResource(String fileName, long size, Resource resource) {
        Assert.hasText((String)fileName, (String)"File name must not be null");
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.fileName = fileName;
        this.size = size;
        this.resource = resource;
    }

    public DownloadResource(TempFileStream tempFileStream) {
        this(tempFileStream.getFileName(), tempFileStream.getLength(), tempFileStream.getOpenedInputStream());
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }
}

