/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.support.WrappedCheckedException;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Exceptions {
    private static final Logger log = LoggerFactory.getLogger(Exceptions.class);

    public static <T> T sneakyThrows(Callable<T> supplier) {
        try {
            return supplier.call();
        }
        catch (Exception e) {
            throw new WrappedCheckedException(e);
        }
    }

    public static boolean safe(Action action) {
        try {
            action.run();
            return true;
        }
        catch (Exception e) {
            log.warn("Safe execution of [{}] failed with", (Object)action, (Object)e);
            return false;
        }
    }

    public static <E extends Throwable> void rethrow(Action action, Function<Throwable, E> mapper) throws E {
        try {
            action.run();
        }
        catch (Throwable t) {
            throw (Throwable)mapper.apply(t);
        }
    }

    public static <T> T silent(Callable<T> supplier, Callable<T> otherwise) {
        return Exceptions.safeOrSilent(supplier, otherwise, true);
    }

    public static <T> T safe(Callable<T> supplier, Callable<T> otherwise) {
        return Exceptions.safeOrSilent(supplier, otherwise, false);
    }

    private static <T> T safeOrSilent(Callable<T> supplier, Callable<T> otherwise, boolean silent) {
        try {
            return supplier.call();
        }
        catch (Exception e) {
            if (!silent) {
                log.warn("Safe execution of [{}] failed with", supplier, (Object)e);
            }
            return Exceptions.sneakyThrows(otherwise);
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void run() throws Exception;
    }
}

