/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.DocumentClass;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;

@Entity
@Table(name="pm_file_name_templates")
@SequenceGenerator(name="pm_file_name_templates_id_seq", sequenceName="pm_file_name_templates_id_seq")
public class FileNameTemplate {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_file_name_templates_id_seq")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassid", nullable=false, unique=true)
    private DocumentClass documentClass;
    @Column(name="template", nullable=false, length=4000)
    private String template;

    public static FileNameTemplateBuilder builder() {
        return new FileNameTemplateBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public FileNameTemplate() {
    }

    @ConstructorProperties(value={"id", "documentClass", "template"})
    public FileNameTemplate(Long id, DocumentClass documentClass, String template) {
        this.id = id;
        this.documentClass = documentClass;
        this.template = template;
    }

    public static class FileNameTemplateBuilder {
        private Long id;
        private DocumentClass documentClass;
        private String template;

        FileNameTemplateBuilder() {
        }

        public FileNameTemplateBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public FileNameTemplateBuilder documentClass(DocumentClass documentClass) {
            this.documentClass = documentClass;
            return this;
        }

        public FileNameTemplateBuilder template(String template) {
            this.template = template;
            return this;
        }

        public FileNameTemplate build() {
            return new FileNameTemplate(this.id, this.documentClass, this.template);
        }

        public String toString() {
            return "FileNameTemplate.FileNameTemplateBuilder(id=" + this.id + ", documentClass=" + String.valueOf(this.documentClass) + ", template=" + this.template + ")";
        }
    }
}

