/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class FileEncodingUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileEncodingUtils.class);
    private static final int BOM_HEADER_LENGTH = 4;
    private static final int XML_DECLARATION_MAX_LENGTH = 300;

    public static Charset detectXmlEncoding(File xmlFile) throws IOException {
        Assert.notNull((Object)xmlFile, (String)"Xml file must not be null");
        FileInputStream inputStream = new FileInputStream(xmlFile);
        try {
            Charset charset = FileEncodingUtils.detectXmlEncoding(inputStream);
            return charset;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset detectXmlEncoding(InputStream inputStream) throws IOException {
        Assert.notNull((Object)inputStream, (String)"Input stream must not be null");
        byte[] header = new byte[300];
        inputStream.mark(header.length);
        Charset charset = FileEncodingUtils.detectBomEncoding(inputStream);
        if (charset != null) {
            return charset;
        }
        try {
            int read = inputStream.read(header);
            charset = FileEncodingUtils.detectPossibleXmlEncoding(header);
            String declaration = new String(header, 0, read, charset).replace('\'', '\"');
            int pos = declaration.indexOf("encoding");
            if (pos > -1) {
                int start = declaration.indexOf(34, pos);
                int end = declaration.indexOf(34, start + 1);
                Charset charset2 = Charset.forName(declaration.substring(start + 1, end));
                return charset2;
            }
        }
        catch (RuntimeException e) {
            logger.info("Nie uda\u0142o si\u0119 odczyta\u0107 kodowania pliku xml", (Throwable)e);
        }
        finally {
            inputStream.reset();
        }
        return Charset.defaultCharset();
    }

    private static Charset detectPossibleXmlEncoding(byte[] head) throws IOException {
        if (head[0] == 0 && head[1] == 0 && head[2] == 0 && head[3] == 60) {
            return Charset.forName("UTF-32");
        }
        if (head[0] == 0 && head[1] == 60 && head[2] == 0 && head[3] == 63) {
            return Charset.forName("UTF-16BE");
        }
        if (head[0] == 60 && head[1] == 0 && head[2] == 63 && head[3] == 0) {
            return Charset.forName("UTF-16LE");
        }
        if (head[0] == 60 && head[1] == 63 && head[2] == 120 && head[3] == 109) {
            return Charset.forName("ASCII");
        }
        if (head[0] == 76 && head[1] == 111 && head[2] == -89 && head[3] == -108) {
            return Charset.forName("CP037");
        }
        return Charset.forName("UTF-8");
    }

    public static Charset detectBomEncoding(InputStream inputStream) throws IOException {
        Assert.notNull((Object)inputStream, (String)"Input stream must not be null");
        Assert.isTrue((boolean)inputStream.markSupported(), (String)"Marking input stream must be supported");
        byte[] bom = new byte[4];
        inputStream.mark(bom.length);
        int skippedBytes = 0;
        int read = inputStream.read(bom, 0, 4);
        if (read < 4) {
            return null;
        }
        Charset charset = null;
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            skippedBytes = 4;
            charset = Charset.forName("UTF-32BE");
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            skippedBytes = 4;
            charset = Charset.forName("UTF-32LE");
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            skippedBytes = 3;
            charset = Charset.forName("UTF-8");
        } else if (bom[0] == -2 && bom[1] == -1) {
            skippedBytes = 2;
            charset = Charset.forName("UTF-16BE");
        } else if (bom[0] == -1 && bom[1] == -2) {
            skippedBytes = 2;
            charset = Charset.forName("UTF-16LE");
        }
        inputStream.reset();
        inputStream.skip(skippedBytes);
        return charset;
    }
}

