/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security.saml;

import com.coveo.saml.SamlClient;
import com.coveo.saml.SamlResponse;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class SamlDecoder {
    public static String decodeUserId(String encodedSaml, String certificateFingerprint) {
        Reader reader = SamlDecoder.readMetadata(certificateFingerprint);
        return SamlDecoder.decodeUserId(encodedSaml, reader);
    }

    public static String decodeUserId(String encodedSaml, Reader reader) {
        SamlClient client = SamlClient.fromMetadata((String)"", (String)"", (Reader)reader);
        SamlResponse response = client.decodeAndValidateSamlResponse(encodedSaml, "POST");
        return response.getNameID();
    }

    private static Reader readMetadata(String certificateFingerprint) throws Exception {
        try (InputStream inputStream = new URL(certificateFingerprint).openStream();){
            StringReader stringReader = new StringReader(IOUtils.toString((InputStream)inputStream));
            return stringReader;
        }
    }
}

