/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import javax.annotation.Nullable;

public class Validations {
    @Nullable
    private Integer arrayMinLength;
    private static final Validations NO_VALIDATION = new Validations();

    public static Validations noValidation() {
        return NO_VALIDATION;
    }

    public <T> void validateParameterType(Type<T> type, @Nullable T defaultValue) {
        if (this.arrayMinLength != null) {
            if (!Types.isArray(type)) {
                throw new InvalidComponentException("`arrayMinLength` validation cannot be applied to non-array type: got " + String.valueOf(type));
            }
            if (defaultValue != null) {
                Object[] array = (Object[])((ArrayType)type).read(defaultValue);
                this.validateValue(array);
            }
        }
    }

    <T> void validateValue(T[] values) {
        if (this.arrayMinLength != null && values.length < this.arrayMinLength) {
            throw new InvalidComponentException(String.format("Validation error: expected `arrayMinLength`=%s got %s", this.arrayMinLength, values.length));
        }
    }

    @Nullable
    public Integer getArrayMinLength() {
        return this.arrayMinLength;
    }

    public void setArrayMinLength(@Nullable Integer arrayMinLength) {
        this.arrayMinLength = arrayMinLength;
    }
}

