/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum DivanteColor {
    ORANGE("orange", "#ff9900"),
    ORANGE_PALE("orange-pale", "#ffae50"),
    BLUE("blue", "#0b5eda"),
    BLUE_ACTIVE("blue-active", "#004cbe"),
    GRAY_PALE("gray-pale", "#cacccf"),
    WHITE("white", "#ffffff"),
    RED("red", "#f1472f"),
    GREEN("green", "#01c768"),
    BLUE_PALE("blue-pale", "#703ffa"),
    TABLE_BLACK("table-black", "#323c47"),
    TABLE_BLACK_ACTIVE("table-black-active", "#000000"),
    TABLE_GRAY("table-gray", "#ababab"),
    DARK_BLUE("dark-blue", "#334d6e"),
    GRAY("gray", "#90a0b7"),
    ICON_GRAY("icon-gray", "#c2cfe0"),
    TABLE_TEXT_GRAY("table-text-gray", "#6b6b6b"),
    ORANGE_DIM("orange-dim", "#ffc575"),
    PURPLE_PALE("purple-pale", "#906efa"),
    PURPLE_DIM("purple-dim", "#ae95fc"),
    BLUE_PASTEL("blue-pastel", "#4a83e1"),
    BLUE_DIM("blue-dim", "#7aa4e9"),
    YELLOW("yellow", "#f0da69"),
    YELLOW_PALE("yellow-pale", "#f5e694"),
    YELLOW_DIM("yellow-dim", "#f3ecb1"),
    GREEN_PALE("green-pale", "#44d38a"),
    GREEN_DIM("green-dim", "#75dfaa"),
    PINK("pink", "#f47362"),
    PINK_PALE("pink-pale", "#f7998c"),
    PINK_DIM("pink-dim", "#fac1b9"),
    BLUE_GREY("blue-grey", "#2d4463"),
    BLUE_GREY_PALE("blue-grey-pale", "#65778e");

    private static final List<DivanteColor> colorsExcludedFromAvatar;
    private String code;
    private String hex;

    private DivanteColor(String code) {
        this.code = code;
    }

    private DivanteColor(String code, String hex) {
        this.code = code;
        this.hex = hex;
    }

    public static DivanteColor fromString(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        return DivanteColor.valueOf(text.trim().toUpperCase());
    }

    public static DivanteColor fromCode(String code) {
        return Stream.of(DivanteColor.values()).filter(icon -> icon.code.equals(code)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static List<DivanteColor> getColorsForAvatar() {
        return Arrays.stream(DivanteColor.values()).filter(divanteColor -> !colorsExcludedFromAvatar.contains(divanteColor)).collect(Collectors.toList());
    }

    public String getCode() {
        return this.code;
    }

    public String getHex() {
        return this.hex;
    }

    static {
        colorsExcludedFromAvatar = Arrays.asList(WHITE, TABLE_BLACK, TABLE_BLACK_ACTIVE);
    }
}

