/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.DefaultCacheConfig;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import java.time.Duration;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserInfoCache {
    @Autowired
    private UserService userService;
    @Autowired
    private CacheFactory cacheFactory;
    private PlusWorkflowCache<String, UserInfo> cache;

    @PostConstruct
    private void init() {
        DefaultCacheConfig<String, UserInfo> cacheConfig = DefaultCacheConfig.builder().expireAfterWrite(Duration.ofMinutes(5L)).loadFunction(this::loadUserInfo).build();
        this.cache = this.cacheFactory.createCache(SystemCacheId.USER_INFO_CACHE, cacheConfig);
    }

    public static UserInfoCache get() {
        return SpringContext.getBean(UserInfoCache.class);
    }

    public UserInfo get(String user) {
        return this.cache.getUnchecked(user);
    }

    public void clear(String ... users) {
        this.cache.invalidateAll(Arrays.asList(users));
    }

    public void clearAll() {
        this.cache.invalidateAll();
    }

    private UserInfo loadUserInfo(String key) {
        User user = TransactionWrapper.get().doInHibernateTransaction(session -> this.userService.getUser(key, "groups", "positions.organizationalUnit", "positions", "positions.higherPosition", "positions.higherPosition.user"));
        if (user == null && !SystemProperties.getBoolean(DefinedSystemParameter.CASE_SENSITIVE_LOGIN).booleanValue()) {
            Object userNameWithDomain = key;
            if (((String)userNameWithDomain).contains("/")) {
                String[] loginSplit = ((String)userNameWithDomain).split("/", 2);
                userNameWithDomain = loginSplit[0] + "/" + loginSplit[1].toLowerCase();
            } else {
                userNameWithDomain = ((String)userNameWithDomain).toLowerCase();
            }
            String finalUserNameWithDomain = userNameWithDomain;
            user = TransactionWrapper.get().doInHibernateTransaction(session -> this.userService.getUser(finalUserNameWithDomain, "groups", "positions.organizationalUnit", "positions", "positions.higherPosition", "positions.higherPosition.user"));
        }
        if (user != null) {
            return new UserInfo(user);
        }
        throw new UserNotFoundException(key);
    }
}

