/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.google.common.collect.Maps;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.BooleanType;
import com.suncode.pwfl.core.type.DateTimeType;
import com.suncode.pwfl.core.type.DateType;
import com.suncode.pwfl.core.type.FileType;
import com.suncode.pwfl.core.type.FloatType;
import com.suncode.pwfl.core.type.FunctionType;
import com.suncode.pwfl.core.type.IntegerType;
import com.suncode.pwfl.core.type.StringType;
import com.suncode.pwfl.core.type.TableStoreType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.VariableType;
import com.suncode.pwfl.customfile.ComponentFile;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.util.Assert;

public final class Types {
    public static final StringType STRING = StringType.INSTANCE;
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final DateType DATE = DateType.INSTANCE;
    public static final DateTimeType DATETIME = DateTimeType.INSTANCE;
    public static final VariableType VARIABLE = VariableType.INSTANCE;
    public static final FunctionType FUNCTION = FunctionType.INSTANCE;
    public static final TableStoreType TABLE_STORE = TableStoreType.INSTANCE;
    public static final FileType FILE = FileType.INSTANCE;
    public static final ArrayType<String> STRING_ARRAY = ArrayType.of(StringType.INSTANCE);
    public static final ArrayType<Boolean> BOOLEAN_ARRAY = ArrayType.of(BooleanType.INSTANCE);
    public static final ArrayType<Long> INTEGER_ARRAY = ArrayType.of(IntegerType.INSTANCE);
    public static final ArrayType<Double> FLOAT_ARRAY = ArrayType.of(FloatType.INSTANCE);
    public static final ArrayType<LocalDate> DATE_ARRAY = ArrayType.of(DateType.INSTANCE);
    public static final ArrayType<LocalDateTime> DATETIME_ARRAY = ArrayType.of(DateTimeType.INSTANCE);
    public static final ArrayType<Variable> VARIABLE_ARRAY = ArrayType.of(VariableType.INSTANCE);
    public static final ArrayType<FunctionCall> FUNCTION_ARRAY = ArrayType.of(FunctionType.INSTANCE);
    public static final ArrayType<ComponentFile> FILE_ARRAY = ArrayType.of(FileType.INSTANCE);
    private static final Type<?>[] types = new Type[]{STRING, BOOLEAN, INTEGER, FLOAT, DATE, DATETIME, FUNCTION, VARIABLE, TABLE_STORE, FILE, STRING_ARRAY, BOOLEAN_ARRAY, INTEGER_ARRAY, FLOAT_ARRAY, DATE_ARRAY, DATETIME_ARRAY, FUNCTION_ARRAY, VARIABLE_ARRAY, FILE_ARRAY};
    private static final Map<String, Type<?>> typesMap = Maps.newHashMap();

    public static Type<?> get(String name) {
        Type<?> type = typesMap.get(name.toLowerCase());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("There is not type with name: " + name);
    }

    public static <T> Type<T> typeOf(T instance) {
        Assert.notNull(instance, (String)"Instance must not be null");
        for (Type<?> type : types) {
            if (!type.isInstance(instance)) continue;
            return type;
        }
        throw new IllegalArgumentException("There is not type representing given instance: " + String.valueOf(instance));
    }

    public static Type<?> typeOf(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        for (Type<?> type : types) {
            if (!type.isInstance(clazz)) continue;
            return type;
        }
        throw new IllegalArgumentException("There is not type representing given class: " + String.valueOf(clazz));
    }

    public static ArrayType<?> arrayOf(Type<?> type) {
        ArrayType<?> arrayType = ArrayType.of(type);
        Type<?> cachedInstance = typesMap.get(arrayType.name());
        if (cachedInstance != null) {
            return (ArrayType)cachedInstance;
        }
        throw new IllegalArgumentException("Cannot create array of: " + String.valueOf(type));
    }

    public static boolean isArray(Type<?> type) {
        return type instanceof ArrayType;
    }

    static {
        for (Type<?> type : types) {
            typesMap.put(type.name(), type);
        }
    }
}

