/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow;

import com.suncode.pwfl.core.context.Context;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.Exceptions;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.DelegatedActivity;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.List;
import org.enhydra.shark.Shark;
import org.springframework.util.Assert;

public abstract class WorkflowContext
implements Context {
    public static final String NAME = "workflowcontext";
    private final String processId;
    private final String activityId;
    protected boolean enableLog = true;

    protected WorkflowContext(String processId, String activityId) {
        Assert.hasText((String)processId, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)activityId, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.processId = processId;
        this.activityId = activityId;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getPackageId() {
        ProcessService processService = SpringContext.getBean("sharkProcessService", ProcessService.class);
        return processService.getProcess(this.processId, "processDefinition").getProcessDefinition().getPackageId();
    }

    public String getProcessDefId() {
        return TransactionWrapper.get().doInSharkTransaction(transaction -> Exceptions.sneakyThrows(() -> Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(transaction, this.processId)));
    }

    public String getActivityDefId() {
        return TransactionWrapper.get().doInSharkTransaction(transaction -> Exceptions.sneakyThrows(() -> Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(transaction, this.processId, this.activityId)));
    }

    protected static void activateFunctionContext(String processId, String activityId) {
        if (!FunctionContext.isActive()) {
            FunctionContext.activate(processId, activityId);
        }
    }

    protected static void deactivateFunctionContext() {
        if (FunctionContext.isActive()) {
            FunctionContext.deactivate();
        }
    }

    public List<DelegatedActivity> getActivityDelegations(String activityId, String userName) {
        return ServiceFactory.getActivityService().getActivityDelegations(activityId, userName);
    }

    public abstract void disableLogging();

    public abstract void enableLogging();

    public boolean isEnableLog() {
        return this.enableLog;
    }
}

