/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.translation;

import com.google.common.collect.Sets;
import com.suncode.pwfl.translation.ClassLoaderTranslator;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.NoTranslationException;
import com.suncode.pwfl.translation.PackageTranslator;
import com.suncode.pwfl.translation.Translator;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public abstract class AbstractTranslator
implements PackageTranslator,
ClassLoaderTranslator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTranslator.class);
    private final Set<String> packages = Sets.newHashSet();
    private Translator parent;
    private SoftReference<ClassLoader> classLoader;

    public AbstractTranslator() {
    }

    public AbstractTranslator(Translator parent) {
        this.parent = parent;
    }

    public void addTranslatedPackage(String packageName) {
        Assert.hasText((String)packageName, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.packages.add(packageName);
    }

    public void setTranslatedClassLoader(ClassLoader classLoader) {
        if (this.classLoader == null) {
            this.classLoader = new SoftReference<ClassLoader>(classLoader);
        }
    }

    public void setParent(Translator parent) {
        this.parent = parent;
    }

    public Translator getParent() {
        return this.parent;
    }

    protected abstract String resolveMessage(String var1, Locale var2, Object ... var3) throws NoTranslationException;

    @Override
    public Set<String> translatedPackages() {
        return this.packages;
    }

    @Override
    public ClassLoader translatedClassLoader() {
        return this.classLoader != null ? this.classLoader.get() : null;
    }

    @Override
    public String getMessage(String key, Locale locale, Object ... args) throws NoTranslationException {
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        try {
            if (key == null) {
                return null;
            }
            if (key.trim().isEmpty()) {
                return "";
            }
            return this.resolveMessage(key, locale, args);
        }
        catch (NoTranslationException e) {
            if (this.parent != null) {
                logger.trace("No message found under key [{}] for locale [{}] in [{}]. Trying parent: [{}]", new Object[]{key, locale, this, this.parent});
                return this.parent.getMessage(key, locale, args);
            }
            throw new NoTranslationException(key, locale);
        }
    }

    @Override
    public String getMessage(String key) throws NoTranslationException {
        return this.getMessage(key, null, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public String getMessage(String key, Locale locale) throws NoTranslationException {
        return this.getMessage(key, locale, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public String getMessage(String key, Object ... args) throws NoTranslationException {
        return this.getMessage(key, null, args);
    }

    @Override
    public LocalizedString getLocalizedString(String key) {
        return this.createLocalizedString(key, null, null, null, new Object[0]);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String defaultValue) {
        return this.createLocalizedString(key, null, defaultValue, null, new Object[0]);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String[] fallbackKeys, String defaultValue) {
        return this.createLocalizedString(key, fallbackKeys, defaultValue, null, new Object[0]);
    }

    @Override
    public LocalizedString getLocalizedString(String key, Locale locale) {
        return this.createLocalizedString(key, null, null, locale, new Object[0]);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String defaultValue, Locale locale) {
        return this.createLocalizedString(key, null, defaultValue, locale, new Object[0]);
    }

    @Override
    public LocalizedString getLocalizedString(String key, Object ... args) {
        return this.createLocalizedString(key, null, null, null, args);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String defaultValue, Object ... args) {
        return this.createLocalizedString(key, null, defaultValue, null, args);
    }

    @Override
    public LocalizedString getLocalizedString(String key, Locale locale, Object ... args) {
        return this.createLocalizedString(key, null, null, locale, args);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String defaultValue, Locale locale, Object ... args) {
        return this.createLocalizedString(key, null, defaultValue, locale, args);
    }

    @Override
    public LocalizedString getLocalizedString(String key, String[] fallbackKeys, String defaultValue, Locale locale, Object ... args) {
        return this.createLocalizedString(key, fallbackKeys, defaultValue, locale, args);
    }

    private LocalizedString createLocalizedString(String key, String[] fallbackKeys, String defaultValue, Locale locale, Object ... args) {
        return new LocalizedString(key, fallbackKeys, defaultValue, this, locale, args);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractTranslator) {
            AbstractTranslator other = (AbstractTranslator)obj;
            return new EqualsBuilder().append((Object)this.parent, (Object)other.parent).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.parent).toHashCode();
    }
}

