/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email;

import com.suncode.pwfl.archive.WfDocument;
import java.beans.ConstructorProperties;
import java.io.File;

public class EmailAttachment {
    private File file;
    private String filename;
    private boolean temp;

    public EmailAttachment(File file) {
        this.file = file;
    }

    public EmailAttachment(File file, String filename) {
        this.file = file;
        this.filename = filename;
    }

    public EmailAttachment(WfDocument wfDocument) {
        this.file = new File(wfDocument.getFile().getFullPath());
        this.filename = wfDocument.getFile().getFileName();
    }

    public String toString() {
        return "EmailAttachment{file=" + this.file + ", filename='" + this.filename + "'}";
    }

    public static EmailAttachmentBuilder builder() {
        return new EmailAttachmentBuilder();
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isTemp() {
        return this.temp;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTemp(boolean temp) {
        this.temp = temp;
    }

    public EmailAttachment() {
    }

    @ConstructorProperties(value={"file", "filename", "temp"})
    public EmailAttachment(File file, String filename, boolean temp) {
        this.file = file;
        this.filename = filename;
        this.temp = temp;
    }

    public static class EmailAttachmentBuilder {
        private File file;
        private String filename;
        private boolean temp;

        EmailAttachmentBuilder() {
        }

        public EmailAttachmentBuilder file(File file) {
            this.file = file;
            return this;
        }

        public EmailAttachmentBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public EmailAttachmentBuilder temp(boolean temp) {
            this.temp = temp;
            return this;
        }

        public EmailAttachment build() {
            return new EmailAttachment(this.file, this.filename, this.temp);
        }

        public String toString() {
            return "EmailAttachment.EmailAttachmentBuilder(file=" + this.file + ", filename=" + this.filename + ", temp=" + this.temp + ")";
        }
    }
}

