/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.assignment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class UserAssignmentDto {
    private String username;
    private String activityDefId;
    private String processDefId;
    private String activityId;
    private String processId;
    private String state;

    public UserAssignmentDto(String username, String activityDefId, String processDefId, String activityId, String processId, String state) {
        this.username = UserAssignmentDto.internSafely(username);
        this.activityDefId = UserAssignmentDto.internSafely(activityDefId);
        this.processDefId = UserAssignmentDto.internSafely(processDefId);
        this.activityId = UserAssignmentDto.internSafely(activityId);
        this.processId = UserAssignmentDto.internSafely(processId);
        this.state = UserAssignmentDto.internSafely(state);
    }

    public static List<UserAssignmentDto> convertToDto(List<Map<String, Object>> assignments) {
        return assignments.stream().map(UserAssignmentDto::convertToDto).collect(Collectors.toList());
    }

    public static UserAssignmentDto convertToDto(Map<String, Object> assignment) {
        String username = Objects.toString(assignment.get("resourceid"), null);
        String processDefId = Objects.toString(assignment.get("processdefinitionid"), null);
        String activityDefId = Objects.toString(assignment.get("activitydefinitionid"), null);
        String activityId = Objects.toString(assignment.get("activityid"), null);
        String processId = Objects.toString(assignment.get("activityprocessid"), null);
        String state = Objects.toString(assignment.get("state"), null);
        return new UserAssignmentDto(username, activityDefId, processDefId, activityId, processId, state);
    }

    public static List<Map<String, Object>> convertToMap(List<UserAssignmentDto> assignments) {
        return assignments.stream().map(UserAssignmentDto::convertToMap).collect(Collectors.toList());
    }

    private static Map<String, Object> convertToMap(UserAssignmentDto assignment) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceid", assignment.getUsername());
        map.put("processdefinitionid", assignment.getProcessDefId());
        map.put("activitydefinitionid", assignment.getActivityDefId());
        map.put("activityid", assignment.getActivityId());
        map.put("activityprocessid", assignment.getProcessId());
        map.put("state", assignment.getState());
        return map;
    }

    public void setUsername(String username) {
        this.username = UserAssignmentDto.internSafely(username);
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = UserAssignmentDto.internSafely(activityDefId);
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = UserAssignmentDto.internSafely(processDefId);
    }

    public void setActivityId(String activityId) {
        this.activityId = UserAssignmentDto.internSafely(activityId);
    }

    public void setProcessId(String processId) {
        this.processId = UserAssignmentDto.internSafely(processId);
    }

    public void setState(String state) {
        this.state = UserAssignmentDto.internSafely(state);
    }

    private static String internSafely(String nullableString) {
        return nullableString != null ? nullableString.intern() : null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getState() {
        return this.state;
    }

    public UserAssignmentDto() {
    }
}

