/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.ComponentDefinitionBuilder;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.Validations;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.translation.LocalizedString;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public class ParameterDefinitionBuilder<T extends ComponentDefinitionBuilder<T>> {
    private final ComponentDefinitionBuilder<T> componentBuilder;
    private String id;
    private LocalizedString name;
    private LocalizedString description;
    private Type<?> type;
    private boolean optional;
    private Object defaultValue;
    private Validations.ValidationsBuilder validations = Validations.builder();
    private List<String> recommendedFunctions = new ArrayList<String>();

    public ParameterDefinitionBuilder(ComponentDefinitionBuilder<T> componentBuilder) {
        Assert.notNull(componentBuilder);
        this.componentBuilder = componentBuilder;
    }

    public ParameterDefinitionBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public ParameterDefinitionBuilder<T> name(String name) {
        this.name = this.componentBuilder.translated(name);
        return this;
    }

    public ParameterDefinitionBuilder<T> description(String description) {
        this.description = this.componentBuilder.translated(description);
        return this;
    }

    public ParameterDefinitionBuilder<T> type(Type<?> type) {
        this.type = type;
        return this;
    }

    public ParameterDefinitionBuilder<T> optional() {
        this.optional = true;
        return this;
    }

    public ParameterDefinitionBuilder<T> defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ParameterDefinitionBuilder<T> arrayMinLength(int length) {
        this.validations.arrayMinLength(length);
        return this;
    }

    public ParameterDefinitionBuilder<T> recommendedFunctions(String ... recommendedFunctions) {
        for (String function : recommendedFunctions) {
            this.recommendedFunctions.add(function);
        }
        return this;
    }

    public T create() {
        ParameterDefinition<Object> parameter = new ParameterDefinition<Object>(this.id, this.type, this.name, this.description, this.optional, this.defaultValue, this.validations.build(), this.recommendedFunctions);
        return this.componentBuilder.parameter(parameter);
    }
}

