/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.configuration.validators;

import com.suncode.pwfl.configuration.validators.ConfigurationTransferValidationErrorType;

public class ConfigurationElementTransferValidatorResult {
    private final State state;
    private ConfigurationTransferValidationErrorType errorType = ConfigurationTransferValidationErrorType.OTHER;
    private final String errorMessage;

    private ConfigurationElementTransferValidatorResult(State state, String errorMessage) {
        this.state = state;
        this.errorMessage = errorMessage;
    }

    private ConfigurationElementTransferValidatorResult(State state, ConfigurationTransferValidationErrorType errorType, String errorMessage) {
        this.state = state;
        this.errorMessage = errorMessage;
        this.errorType = errorType;
    }

    public static ConfigurationElementTransferValidatorResult ok() {
        return new ConfigurationElementTransferValidatorResult(State.OK, null, null);
    }

    public static ConfigurationElementTransferValidatorResult error(String errorMessage) {
        return new ConfigurationElementTransferValidatorResult(State.ERROR, errorMessage);
    }

    public static ConfigurationElementTransferValidatorResult error(ConfigurationTransferValidationErrorType errorType, String errorMessage) {
        return new ConfigurationElementTransferValidatorResult(State.ERROR, errorType, errorMessage);
    }

    public boolean isOK() {
        return this.state == State.OK;
    }

    public String getErrorMessage() {
        if (this.isOK()) {
            return "";
        }
        return this.errorMessage;
    }

    public ConfigurationTransferValidationErrorType getErrorType() {
        return this.errorType;
    }

    public String toString() {
        return "ConfigurationTransferValidationResult [state=" + (Object)((Object)this.state) + ", errorType=" + (Object)((Object)this.errorType) + ", errorMessage=" + this.errorMessage + "]";
    }

    private static enum State {
        OK,
        ERROR;

    }
}

