/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class CollatorInstance {
    private static final Logger log = LoggerFactory.getLogger(CollatorInstance.class);
    private static LoadingCache<Locale, Collator> collators = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(CollatorInstance::getCollator));

    public static Collator get() {
        Locale locale = LocaleContextHolder.getLocale();
        try {
            return (Collator)collators.get((Object)locale);
        }
        catch (ExecutionException e) {
            return CollatorInstance.getCollator(locale);
        }
    }

    private static Collator getCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        try {
            String rules = ((RuleBasedCollator)collator).getRules();
            rules = rules.replaceAll("<'_'", "<' '<'_'");
            return new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            log.error("Could not change rule for collator with locale {}", (Object)LocaleContextHolder.getLocale().getLanguage());
            return collator;
        }
    }
}

