/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.util;

import com.suncode.pwfl.audit.util.AuditTypes;

public enum AuditCategories {
    AUDIT_LOGGING,
    AUDIT_ACTIVITY,
    AUDIT_PROCESS,
    AUDIT_ARCHIVE,
    AUDIT_ADMINISTRATION,
    AUDIT_USER,
    AUDIT_REPORTS;


    public static String getCategoryNameForAudit(AuditTypes auditType) {
        switch (auditType) {
            case AUDIT_LOG_IN: 
            case AUDIT_LOG_IN_UNIVERSAL_PASSWORD: 
            case AUDIT_LOG_OUT: {
                return AUDIT_LOGGING.toString();
            }
            case AUDIT_SEARCH_ACTIVITIES: 
            case AUDIT_OPEN_ACTIVITY: 
            case AUDIT_SAVE_ACTIVITY: 
            case AUDIT_ACCEPT_ACTIVITY: 
            case AUDIT_VALIDATE_ACTIVITY: 
            case AUDIT_ADD_COMMENT_TO_ACTIVITY: 
            case AUDIT_DELETE_COMMENT_FROM_ACTIVITY: 
            case AUDIT_ACTIVITY_DETAILS: 
            case AUDIT_CHECK_IN_DOCUMENT_FROM_ACTIVITY: 
            case AUDIT_SUSPEND_ACTIVITY: 
            case AUDIT_SUSPEND_ACTIVITIES: 
            case AUDIT_ABORT_ACTIVITY: 
            case AUDIT_ACCEPT_MANY_ACTIVITIES: 
            case AUDIT_RESUME_ACTIVITIES: 
            case AUDIT_OPEN_USER_ACTIVITIES: 
            case AUDIT_OPEN_USER_FINISHED_ACTIVITIES: {
                return AUDIT_ACTIVITY.toString();
            }
            case AUDIT_CREATE_PROCESS: 
            case AUDIT_SEARCH_PROCESSES: 
            case AUDIT_UPLOAD_FILE_FROM_PROCESS: 
            case AUDIT_DELETE_DOCUMENT_FROM_PROCESS: 
            case AUDIT_PROCESS_DETAILS: 
            case AUDIT_DELETE_PROCESS: 
            case AUDIT_DELETE_PROCESSES: 
            case AUDIT_ABORT_PROCESS: 
            case AUDIT_SAVE_VIEW: 
            case AUDIT_DELETE_VIEW: 
            case AUDIT_RUN_VIEW: 
            case AUDIT_SEARCH_PROCESSES_OR_ACTIVITIES: {
                return AUDIT_PROCESS.toString();
            }
            case AUDIT_SEARCH_DOCCLASS: 
            case AUDIT_SEARCH_LINK: 
            case AUDIT_UPLOAD_FILE_FROM_ARCHIVE: 
            case AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE: 
            case AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE: 
            case AUDIT_EDIT_DOCUMENT_INDEXES: {
                return AUDIT_ARCHIVE.toString();
            }
            case AUDIT_SEARCH_USER: 
            case AUDIT_ADD_USER: 
            case AUDIT_IMPORT_USER_FROM_LDAP: 
            case AUDIT_UPDATE_USER: 
            case AUDIT_DELETE_USER: 
            case AUDIT_UPDATE_USER_SETTINGS_GLOBAL: 
            case AUDIT_ADD_GROUP: 
            case AUDIT_UPDATE_GROUP: 
            case AUDIT_DELETE_GROUP: 
            case AUDIT_ADD_USER_TO_GROUP: 
            case AUDIT_DELETE_USER_FROM_GROUP: 
            case AUDIT_ADD_SYSTEM_PROTECTION: 
            case AUDIT_DELETE_SYSTEM_PROTECTION: 
            case AUDIT_ADD_DELEGATION: 
            case AUDIT_DELETE_DELEGATION: 
            case AUDIT_ADD_POSITION: 
            case AUDIT_UPDATE_POSITION: 
            case AUDIT_DELETE_POSITION: 
            case AUDIT_SEARCH_POSITION: 
            case AUDIT_ADD_ORG_UNIT: 
            case AUDIT_UPDATE_ORG_UNIT: 
            case AUDIT_DELETE_ORG_UNIT: 
            case AUDIT_SEARCH_ORG_UNIT: 
            case AUDIT_ADD_DOCCLASS: 
            case AUDIT_UPDATE_DOCCLASS: 
            case AUDIT_DELETE_DOCCLASS: 
            case AUDIT_ADD_LINK: 
            case AUDIT_UPDATE_LINK: 
            case AUDIT_DELETE_LINK: 
            case AUDIT_ADD_DIRECTORY: 
            case AUDIT_DELETE_DIRECTORY: 
            case AUDIT_UPDATE_DIRECTORY: 
            case AUDIT_ADD_DEVICE: 
            case AUDIT_UPDATE_DEVICE: 
            case AUDIT_DELETE_DEVICE: 
            case AUDIT_ADD_LDAP_SERVER: 
            case AUDIT_UPDATE_LDAP_SERVER: 
            case AUDIT_DELETE_LDAP_SERVER: 
            case AUDIT_ADD_ROLE_TO_POSITION: 
            case AUDIT_DELETE_ROLE_FROM_POSITION: 
            case AUDIT_ADD_NOTIFICATION: 
            case AUDIT_EDIT_NOTIFICATION: 
            case AUDIT_DELETE_NOTIFICATION: 
            case AUDIT_ADD_DOCUMENT_TEMPLATE: 
            case AUDIT_EDIT_DOCUMENT_TEMPLATE: 
            case AUDIT_DELETE_DOCUMENT_TEMPLATE: 
            case AUDIT_ADD_DOC_CLASS_INDEX: 
            case AUDIT_UPDATE_DOC_CLASS_INDEX: 
            case AUDIT_DELETE_DOC_CLASS_INDEX: 
            case AUDIT_ENABLE_USER_NOTIFICATIONS: 
            case AUDIT_DISABLE_USER_NOTIFICATIONS: 
            case AUDIT_ADD_DOC_CLASS_ACTION: 
            case AUDIT_EDIT_DOC_CLASS_ACTION: 
            case AUDIT_DELETE_DOC_CLASS_ACTION: 
            case AUDIT_ADD_PROCESS_PROTECTION: 
            case AUDIT_EDIT_PROCESS_PROTECTION: 
            case AUDIT_DELETE_PROCESS_PROTECTION: 
            case AUDIT_INSTALL_MODULE: 
            case AUDIT_UNINSTALL_MODULE: 
            case AUDIT_ADD_DOCUMENT_VIEW: 
            case AUDIT_EDIT_DOCUMENT_VIEW: 
            case AUDIT_DELETE_DOCUMENT_VIEW: 
            case AUDIT_SAVE_PROCESS_SETTINGS: 
            case AUDIT_LOAD_LICENSE: 
            case AUDIT_ADD_DOC_CLASS_PROTECTION: 
            case AUDIT_EDIT_DOC_CLASS_PROTECTION: 
            case AUDIT_DELETE_DOC_CLASS_PROTECTION: 
            case AUDIT_ADD_DOC_CLASS_PROTECTION_CONDITION: 
            case AUDIT_DELETE_DOC_CLASS_PROTECTION_CONDITION: 
            case AUDIT_ADD_LINK_INDEX: 
            case AUDIT_EDIT_LINK_INDEX: 
            case AUDIT_DELETE_LINK_INDEX: 
            case AUDIT_ADD_LINK_CONNECTION: 
            case AUDIT_DELETE_LINK_CONNECTION: 
            case AUDIT_ADD_LINK_PROTECTION: 
            case AUDIT_EDIT_LINK_PROTECTION: 
            case AUDIT_DELETE_LINK_PROTECTION: 
            case AUDIT_EDIT_USER_NOTIFICATIONS: 
            case AUDIT_DELETE_USER_NOTIFICATIONS: 
            case AUDIT_LOAD_PACKAGE: 
            case AUDIT_UPDATE_PACKAGE: 
            case AUDIT_CLOSE_PACKAGE: 
            case AUDIT_CLEAR_PACKAGE: 
            case AUDIT_ADD_MODULE_RIGHT: 
            case AUDIT_DELETE_MODULE_RIGHT: 
            case AUDIT_ADD_SCHEDULED_TASK: 
            case AUDIT_UPDATE_SCHEDULED_TASK: 
            case AUDIT_DELETE_SCHEDULED_TASK: 
            case AUDIT_RUN_SCHEDULED_TASK: 
            case AUDIT_MANUAL_RUN_SCHEDULED_TASK: 
            case AUDIT_STOP_SCHEDULED_TASK: 
            case AUDIT_INSTALL_PLUGIN_LICENSE: 
            case AUDIT_INSTALL_PLUGIN: 
            case AUDIT_UPDATE_PLUGIN: 
            case AUDIT_START_PLUGIN: 
            case AUDIT_STOP_PLUGIN: 
            case AUDIT_DELETE_PLUGIN: 
            case AUDIT_CONFIG_TRANSFER_EXPORT: 
            case AUDIT_CONFIG_TRANSFER_GET_FROM_BASE: 
            case AUDIT_CONFIG_TRANSFER_GET_FROM_FILE: 
            case AUDIT_CONFIG_TRANSFER_IMPORT: 
            case AUDIT_SYSTEM_PARAMETER_CREATED: 
            case AUDIT_SYSTEM_PARAMETER_REMOVED: 
            case AUDIT_SYSTEM_PARAMETER_CHANGED: 
            case AUDIT_PASSWORD_PROFILE_CREATED: 
            case AUDIT_PASSWORD_PROFILE_CHANGED: 
            case AUDIT_PASSWORD_PROFILE_REMOVED: 
            case AUDIT_PASSWORD_PROFILE_PRIORITY_CHANGED: 
            case AUDIT_PASSWORD_PROFILES_ASSIGNED: 
            case AUDIT_CERTIFICATES_ADDED: 
            case AUDIT_CERTIFICATES_RENAMED: 
            case AUDIT_CERTIFICATES_REMOVED: 
            case AUDIT_DEACTIVATE_USER: 
            case AUDIT_ACTIVATE_USER: 
            case AUDIT_EDIT_DEACTIVATED_USER: 
            case AUDIT_IMPORT_USERS_FROM_GROUP_TO_GROUP: 
            case AUDIT_BLOCK_USER_BY_ADMIN: 
            case AUDIT_UNLOCK_USER_BY_ADMIN: 
            case AUDIT_ASSIGN_POSITION_TO_USER: 
            case AUDIT_DETACH_POSITION: 
            case AUDIT_ADMIN_ADD_DOC_CLASS_ASSOCIATION: 
            case AUDIT_ADMIN_DELETE_DOC_CLASS_ASSOCIATION: 
            case AUDIT_ADMIN_UPDATE_DOC_CLASS_ASSOCIATION: 
            case AUDIT_ADD_REPLACEMENT_VARIABLE: 
            case AUDIT_DELETE_REPLACEMENT_VARIABLE: 
            case AUDIT_CHANGE_REPLACEMENT_VAR_TYPE: 
            case AUDIT_ADD_EMAIL_CONFIGURATION: 
            case AUDIT_UPDATE_EMAIL_CONFIGURATION: 
            case AUDIT_DELETE_EMAIL_CONFIGURATION: 
            case AUDIT_TEST_EMAIL_CONFIGURATION: 
            case AUDIT_ADD_OAUTH2_CLIENT: 
            case AUDIT_UPDATE_OAUTH2_CLIENT: 
            case AUDIT_DELETE_OAUTH2_CLIENT: 
            case AUDIT_OAUTH2_REDIRECT: 
            case AUDIT_DELETE_OAUTH2_CONNECTION: 
            case AUDIT_LOGGER_LEVEL_CHANGED: 
            case AUDIT_LOGGER_LEVEL_RESET: 
            case AUDIT_ALL_LOGGERS_LEVEL_RESET: 
            case AUDIT_SEARCH_USERS: 
            case AUDIT_SEARCH_MAPPINGS: 
            case AUDIT_SEARCH_SUBSTITUTIONS: 
            case AUDIT_ACTIVATE_TRIAL_LICENSE: 
            case AUDIT_IMPORT_TRANSLATIONS: 
            case AUDIT_EDIT_LINK_CONNECTION: 
            case AUDIT_CHANGE_SELECTED_PROCESS_FIELDS: 
            case AUDIT_CHANGE_SELECTED_TASK_FIELDS: 
            case AUDIT_CHANGE_SELECTED_PROCESS_HEADER_FIELDS: {
                return AUDIT_ADMINISTRATION.toString();
            }
            case AUDIT_STATS: 
            case AUDIT_UPDATE_USER_SETTINGS: 
            case AUDIT_CHANGE_PASSWORD: 
            case AUDIT_SELF_PASSWORD_ASSIGN: 
            case AUDIT_ADD_DELEGATION_BY_USER: 
            case AUDIT_DELETE_DELEGATION_BY_USER: 
            case AUDIT_ADD_PANEL_PARAMETER: 
            case AUDIT_DELETE_PANEL_PARAMETER: 
            case AUDIT_UPDATE_PANEL_PARAMETER: 
            case AUDIT_UPDATE_PANEL: 
            case AUDIT_UPDATE_VIEW: 
            case AUDIT_ADD_VIEW_PROTECTION: 
            case AUDIT_DELETE_VIEW_PROTECTION: 
            case AUDIT_EDIT_VIEW_PROTECTION: 
            case AUDIT_ADD_VARIABLE_DISTINGUISH: 
            case AUDIT_UPDATE_VARIABLE_DISTINGUISH: 
            case AUDIT_DELETE_VARIABLE_DISTINGUISH: 
            case AUDIT_ADD_CALENDAR_SHARE: 
            case AUDIT_DELETE_CALENDAR_SHARE: {
                return AUDIT_USER.toString();
            }
            case AUDIT_ADD_VIEW_REPORT: 
            case AUDIT_ADD_SQL_QUERY_REPORT: 
            case AUDIT_ADD_JASPER_REPORT: 
            case AUDIT_EDIT_JASPER_REPORT: 
            case AUDIT_RUN_VIEW_REPORT: 
            case AUDIT_RUN_SQL_QUERY_REPORT: 
            case AUDIT_RUN_JASPER_REPORT: 
            case AUDIT_RUN_SAVED_REPORT: 
            case AUDIT_FILTER_REPORT: {
                return AUDIT_REPORTS.toString();
            }
        }
        return "NONE";
    }
}

