/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.structure;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.translation.configElements.OrganizationalUnitTranslation;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.Hibernate;

@Entity
@Table(name="pm_organizationalunits")
@SequenceGenerator(name="pm_organizationalunits_seq", sequenceName="pm_organizationalUnits_id_seq")
public class OrganizationalUnit {
    public static final String JOIN_HIGHER_ORGANIZATIONAL_UNIT = "higherOrganizationalUnit";
    public static final String JOIN_DIRECTOR_POSITION = "directorPosition";
    public static final String JOIN_SUB_OUS = "subOus";
    public static final String JOIN_TRANSLATIONS = "translations";
    public static final String NAME_COLUMN_NAME = "organizationalunitname";
    private String name;
    private Long id;
    private String symbol;
    private OrganizationalUnit higherOrganizationalUnit;
    private Position directorPosition;
    private Set<OrganizationalUnit> subOus;
    private List<OrganizationalUnitTranslation> translations;

    public OrganizationalUnit() {
    }

    OrganizationalUnit(Long id) {
        this.id = id;
    }

    public OrganizationalUnit(String name, String symbol) {
        this.setName(name);
        this.setSymbol(symbol);
    }

    @Column(name="organizationalunitname")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_organizationalunits_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="organizationalunitsymbol", unique=true, nullable=false)
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="higherorganizationalunitid")
    public OrganizationalUnit getHigherOrganizationalUnit() {
        return this.higherOrganizationalUnit;
    }

    public void setHigherOrganizationalUnit(OrganizationalUnit higherOrganizationalUnit) {
        this.higherOrganizationalUnit = higherOrganizationalUnit;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="directorpositionid")
    public Position getDirectorPosition() {
        return this.directorPosition;
    }

    public void setDirectorPosition(Position directorPosition) {
        this.directorPosition = directorPosition;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST}, mappedBy="higherOrganizationalUnit")
    public Set<OrganizationalUnit> getSubOus() {
        return this.subOus;
    }

    public void setSubOus(Set<OrganizationalUnit> subOus) {
        this.subOus = subOus;
        if (subOus != null && Hibernate.isInitialized(this.subOus)) {
            for (OrganizationalUnit sub : subOus) {
                sub.setHigherOrganizationalUnit(this);
            }
        }
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="translatedEntity", cascade={CascadeType.REMOVE})
    public List<OrganizationalUnitTranslation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<OrganizationalUnitTranslation> translations) {
        this.translations = translations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrganizationalUnit other = (OrganizationalUnit)obj;
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }
}

