/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkIndex;
import java.beans.ConstructorProperties;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_linkconnection")
@SequenceGenerator(name="pm_linkconnection_id_seq", sequenceName="pm_linkconnection_id_seq")
public class LinkConnection {
    public static final String JOIN_LINKS = "link";
    public static final String JOIN_LINK_INDICES = "linkIndex";
    public static final String JOIN_DOCUMENT_CLASSES = "documentClass";
    public static final String JOIN_DOCUMENT_CLASS_INDICES = "documentClassIndex";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_linkconnection_id_seq")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="linkid")
    private Link link;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="linkindexid")
    private LinkIndex linkIndex;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassid")
    private DocumentClass documentClass;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="indexid")
    private DocumentClassIndex documentClassIndex;

    public static LinkConnectionBuilder builder() {
        return new LinkConnectionBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Link getLink() {
        return this.link;
    }

    public LinkIndex getLinkIndex() {
        return this.linkIndex;
    }

    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public DocumentClassIndex getDocumentClassIndex() {
        return this.documentClassIndex;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setLinkIndex(LinkIndex linkIndex) {
        this.linkIndex = linkIndex;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    public void setDocumentClassIndex(DocumentClassIndex documentClassIndex) {
        this.documentClassIndex = documentClassIndex;
    }

    public LinkConnection() {
    }

    @ConstructorProperties(value={"id", "link", "linkIndex", "documentClass", "documentClassIndex"})
    public LinkConnection(Long id, Link link, LinkIndex linkIndex, DocumentClass documentClass, DocumentClassIndex documentClassIndex) {
        this.id = id;
        this.link = link;
        this.linkIndex = linkIndex;
        this.documentClass = documentClass;
        this.documentClassIndex = documentClassIndex;
    }

    public static class LinkConnectionBuilder {
        private Long id;
        private Link link;
        private LinkIndex linkIndex;
        private DocumentClass documentClass;
        private DocumentClassIndex documentClassIndex;

        LinkConnectionBuilder() {
        }

        public LinkConnectionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkConnectionBuilder link(Link link) {
            this.link = link;
            return this;
        }

        public LinkConnectionBuilder linkIndex(LinkIndex linkIndex) {
            this.linkIndex = linkIndex;
            return this;
        }

        public LinkConnectionBuilder documentClass(DocumentClass documentClass) {
            this.documentClass = documentClass;
            return this;
        }

        public LinkConnectionBuilder documentClassIndex(DocumentClassIndex documentClassIndex) {
            this.documentClassIndex = documentClassIndex;
            return this;
        }

        public LinkConnection build() {
            return new LinkConnection(this.id, this.link, this.linkIndex, this.documentClass, this.documentClassIndex);
        }

        public String toString() {
            return "LinkConnection.LinkConnectionBuilder(id=" + this.id + ", link=" + this.link + ", linkIndex=" + this.linkIndex + ", documentClass=" + this.documentClass + ", documentClassIndex=" + this.documentClassIndex + ")";
        }
    }
}

