/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.support;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Transactional;

public class CustomService<T, PK> {
    protected Class<T> type;
    private SessionFactory sessionFactory;

    CustomService() {
    }

    public CustomService(Class<T> type) {
        this.type = type;
    }

    @Transactional
    public void update(T entity) {
        this.getSession().update(entity);
    }

    @Transactional
    public void delete(T entity) {
        this.getSession().delete(entity);
    }

    @Transactional
    public PK save(T entity) {
        return (PK)this.getSession().save(entity);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    @Transactional
    public List<T> findByCriteria(DetachedCriteria dc) {
        return dc.getExecutableCriteria(this.getSession()).list();
    }

    @Transactional
    public List<T> findByCriteria(DetachedCriteria dc, int start, int limit) {
        return dc.getExecutableCriteria(this.getSession()).setMaxResults(limit).setFirstResult(start).list();
    }

    @Transactional
    public T get(PK id) {
        return (T)this.getSession().get(this.type, (Serializable)id);
    }

    @Transactional
    public List<T> getAll() {
        return this.getAll(new String[0]);
    }

    @Transactional
    public List<T> getAll(String ... joins) {
        Criteria criteria = this.getSession().createCriteria(this.type);
        for (String join : joins) {
            criteria.setFetchMode(join, FetchMode.JOIN);
        }
        return criteria.list();
    }

    @Transactional
    public List<T> getAll(int start, int limit) {
        return this.getAll(start, limit, new String[0]);
    }

    @Transactional
    public List<T> getAll(int start, int limit, String ... joins) {
        Criteria criteria = this.getSession().createCriteria(this.type).setFirstResult(start).setMaxResults(limit);
        for (String join : joins) {
            criteria.setFetchMode(join, FetchMode.JOIN);
        }
        return criteria.list();
    }

    @Transactional
    public T get(PK id, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(this.type);
        dc.add(Restrictions.idEq(id));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List<T> list = this.findByCriteria(dc);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Transactional
    public T getByField(String field, Object value, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(this.type);
        dc.add((Criterion)Restrictions.eq((String)field, (Object)value));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List<T> list = this.findByCriteria(dc);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Transactional
    public void delete(Iterable<PK> ids) {
        for (PK id : ids) {
            T obj = this.get(id);
            this.delete(obj);
        }
    }
}

