/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public class ValidationStatus {
    private static final Logger logger = LoggerFactory.getLogger(ValidationStatus.class);
    private MessageSource messageSource;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private String getLocalizedMessage(String message, Object ... args) {
        Assert.hasText((String)message, (String)"Validation message must not be empty");
        if (this.messageSource != null) {
            try {
                return this.messageSource.getMessage(message, args, LocaleContextHolder.getLocale());
            }
            catch (NoSuchMessageException e) {
                logger.warn("No message for key [" + message + "]", (Throwable)e);
                return message;
            }
        }
        return message;
    }

    public void error(String message, Object ... args) {
        String localizedMessage = this.getLocalizedMessage(message, args);
        logger.error("Validation (error): " + localizedMessage);
        this.errors.add(localizedMessage);
    }

    public void warning(String message, Object ... args) {
        String localizedMessage = this.getLocalizedMessage(message, args);
        logger.warn("Validation (warning): " + localizedMessage);
        this.warnings.add(localizedMessage);
    }

    public boolean isValid() {
        return this.errors.size() == 0;
    }
}

