/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.config.InvalidPluginDescriptorException;
import com.suncode.plugin.framework.config.InvalidPluginException;
import com.suncode.plugin.framework.config.MissingPluginDescriptorException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.config.PluginDescriptor;
import com.suncode.plugin.framework.config.PluginDetails;
import com.suncode.plugin.framework.config.URITemplate;
import com.suncode.plugin.framework.config.ValidationStatus;
import com.suncode.plugin.framework.license.FreeLicenseValidator;
import com.suncode.plugin.framework.requirements.Requirement;
import com.suncode.plugin.framework.requirements.Requirements;
import com.suncode.plugin.framework.util.PluginFrameworkUtils;
import com.suncode.plugin.framework.util.ValidationUtils;
import com.suncode.plugin.framework.util.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginDescriptorReader {
    public static final String KEY_ATTRIBUTE = "key";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String HOOK_ATTRIBUTE = "hook";
    public static final String PLUGIN_DETAILS_ELEMENT = "plugin-details";
    public static final String PLUGIN_DETAILS_DESCRIPTION_ELEMENT = "description";
    public static final String PLUGIN_DETAILS_AUTHOR_ELEMENT = "author";
    public static final String LOCALIZED_PROPERTY_ELEMENT = "localized";
    public static final String LOCALIZED_PROPERTY_LANGUAGE_ATTRIBUTE = "language";
    public static final String PLUGIN_DETAILS_DOCUMENTATION_ELEMENT = "documentation";
    public static final String PLUGIN_DETAILS_CHANGELOG_ELEMENT = "changelog";
    private final MessageSource messageSource;

    public PluginDescriptorReader() {
        this((MessageSource)new StaticMessageSource());
    }

    public PluginDescriptorReader(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public PluginDescriptor readDescriptor(File pluginSource) throws InvalidPluginException {
        Assert.notNull((Object)pluginSource, (String)"Plugin file must not be null");
        Resource descriptor = PluginFrameworkUtils.getDescriptorResource(pluginSource);
        if (!descriptor.exists()) {
            throw new MissingPluginDescriptorException();
        }
        return this.readDescriptor(descriptor);
    }

    public PluginDescriptor readDescriptor(Resource descriptor) throws InvalidPluginException {
        Assert.notNull((Object)descriptor, (String)"Descriptor reasource must not be null");
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = descriptor.getInputStream();
            document = XmlUtils.loadDocument(inputStream);
        }
        catch (Exception e) {
            throw new InvalidPluginException("Nie uda\u0142o si\u0119 odczyta\u0107 pliku XML deskryptora wtyczki", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        ValidationStatus validationStatus = new ValidationStatus();
        validationStatus.setMessageSource(this.messageSource);
        return this.doReadDescriptor(document, validationStatus);
    }

    protected PluginDescriptor doReadDescriptor(Document document, ValidationStatus validationStatus) throws InvalidPluginDescriptorException {
        Assert.notNull((Object)document, (String)"Document must not be null");
        Assert.notNull((Object)document, (String)"ValidationStatus must not be null");
        Element root = document.getDocumentElement();
        String key = root.getAttribute(KEY_ATTRIBUTE);
        String name = root.getAttribute(NAME_ATTRIBUTE);
        String hook = root.getAttribute(HOOK_ATTRIBUTE);
        this.validateDescriptor(key, name, validationStatus);
        PluginDetails details = this.readPluginDetails(XmlUtils.getFirstChildElement(PLUGIN_DETAILS_ELEMENT, root), key);
        List<ModuleDefinition> moduleDefinitions = this.readModuleDefinitions(this.getModuleDefinitionElements(root), validationStatus);
        if (validationStatus.isValid()) {
            return new PluginDescriptor(key, name, hook, details, moduleDefinitions);
        }
        throw new InvalidPluginDescriptorException(validationStatus);
    }

    protected void validateDescriptor(String key, String name, ValidationStatus validationStatus) {
        if (!StringUtils.hasText((String)key)) {
            validationStatus.error("plugin.descriptor.key.empty", new Object[0]);
        } else if (!ValidationUtils.isProperKey(key)) {
            validationStatus.error("plugin.descriptor.key.invalid", new Object[0]);
        }
        if (!StringUtils.hasText((String)name)) {
            validationStatus.error("plugin.descriptor.name.empty", new Object[0]);
        }
    }

    protected PluginDetails readPluginDetails(Element details, String pluginKey) {
        if (details == null) {
            return PluginDetails.none();
        }
        return PluginDetails.builder().requirements(this.getRequirements(details, this.readFreeLicense(details, pluginKey))).description(this.getLocalizedProperty(PLUGIN_DETAILS_DESCRIPTION_ELEMENT, details)).author(this.getLocalizedProperty(PLUGIN_DETAILS_AUTHOR_ELEMENT, details)).documentation(this.getUriTemplate(PLUGIN_DETAILS_DOCUMENTATION_ELEMENT, details)).changelog(this.getUriTemplate(PLUGIN_DETAILS_CHANGELOG_ELEMENT, details)).build();
    }

    private PluginDetails.LocalizedProperty getLocalizedProperty(String name, Element parentElement) {
        Assert.hasText((String)name, (String)"Property name must not be null");
        Assert.notNull((Object)parentElement, (String)"Parent element must not be null");
        Element element = XmlUtils.getFirstChildElement(name, parentElement);
        if (element == null) {
            return null;
        }
        NodeList localized = element.getElementsByTagName(LOCALIZED_PROPERTY_ELEMENT);
        if (localized.getLength() == 0) {
            PluginDetails.PropertyTranslation translation = new PluginDetails.PropertyTranslation(element.getTextContent(), Locale.getDefault().getLanguage());
            return new PluginDetails.LocalizedProperty(translation);
        }
        ArrayList<PluginDetails.PropertyTranslation> translations = new ArrayList<PluginDetails.PropertyTranslation>();
        for (int i = 0; i < localized.getLength(); ++i) {
            Element localizedElement = (Element)localized.item(i);
            PluginDetails.PropertyTranslation translation = new PluginDetails.PropertyTranslation(localizedElement.getTextContent(), localizedElement.getAttribute(LOCALIZED_PROPERTY_LANGUAGE_ATTRIBUTE));
            translations.add(translation);
        }
        return new PluginDetails.LocalizedProperty(translations.toArray(new PluginDetails.PropertyTranslation[translations.size()]));
    }

    private Requirements getRequirements(Element parentElement, boolean hasFreeLicense) {
        Element requirements = XmlUtils.getFirstChildElement("requirements", parentElement);
        if (requirements == null) {
            return Requirements.licenseRequired(!hasFreeLicense);
        }
        return Requirements.builder().licenseRequired(!hasFreeLicense).requirements(XmlUtils.getChildElements(requirements).stream().map(element -> {
            String versionText = element.getTextContent();
            boolean optional = XmlUtils.getAttribute("optional", element).map(Boolean::valueOf).orElse(false);
            List<Version> requiredVersions = Arrays.stream(versionText.split(",")).map(String::trim).map(Version::parse).collect(Collectors.toList());
            return new Requirement(element.getTagName(), requiredVersions, optional);
        }).collect(Collectors.toList())).build();
    }

    private URITemplate getUriTemplate(String type, Element parentElement) {
        return XmlUtils.getOnlyChildElementValue(type, parentElement).map(URITemplate::new).orElse(null);
    }

    private boolean readFreeLicense(Element parentElement, String pluginKey) {
        Element freeLicense = XmlUtils.getFirstChildElement("free-license", parentElement);
        if (freeLicense == null) {
            return false;
        }
        try {
            String licenseValue = freeLicense.getTextContent();
            if (StringUtils.hasText((String)licenseValue)) {
                FreeLicenseValidator.validate(licenseValue, pluginKey);
                return true;
            }
            throw new InvalidPluginException("Free license has invalid value.");
        }
        catch (Exception e) {
            throw new InvalidPluginException("Free license has invalid value.", e);
        }
    }

    protected List<ModuleDefinition> readModuleDefinitions(List<Element> moduleElements, ValidationStatus validationStatus) {
        Assert.notNull(moduleElements, (String)"[Assertion failed] - this argument is required; it must not be null");
        ArrayList<String> usedKeys = new ArrayList<String>();
        ArrayList<ModuleDefinition> modules = new ArrayList<ModuleDefinition>(moduleElements.size());
        for (Element element : moduleElements) {
            ModuleDefinition moduleDefinition = this.readModuleDefinition(element, usedKeys, validationStatus);
            modules.add(moduleDefinition);
        }
        return modules;
    }

    protected ModuleDefinition readModuleDefinition(Element moduleElement, List<String> usedKeys, ValidationStatus validationStatus) {
        String name = moduleElement.getNodeName();
        String key = moduleElement.getAttribute(KEY_ATTRIBUTE);
        if (!StringUtils.hasText((String)key)) {
            validationStatus.error("plugin.descriptor.module.key.empty", name);
        } else {
            if (!ValidationUtils.isProperKey(key)) {
                validationStatus.error("plugin.descriptor.module.key.invalid", name, key);
            }
            if (usedKeys.contains(key)) {
                validationStatus.error("plugin.descriptor.module.key.duplicated", key);
            }
        }
        usedKeys.add(key);
        return new ModuleDefinition(name, key, moduleElement);
    }

    private List<Element> getModuleDefinitionElements(Element root) {
        Assert.notNull((Object)root, (String)"XML element must not be null");
        NodeList nodes = root.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || node.getNodeName().equals(PLUGIN_DETAILS_ELEMENT)) continue;
            result.add((Element)node);
        }
        return result;
    }
}

