/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class FrameworkConfiguration {
    private File homeDirectory;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public FrameworkConfiguration(File homeDirectory) {
        this(homeDirectory, null);
    }

    public FrameworkConfiguration(File homeDirectory, Map<String, Object> properties) {
        Assert.notNull((Object)homeDirectory, (String)"Home directory must not be null");
        this.homeDirectory = homeDirectory;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public FrameworkConfiguration withHomeDirectory(File homeDirectory) {
        return new FrameworkConfiguration(homeDirectory, this.properties);
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void addProperty(String name, Object value) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, value);
        }
    }

    public void addProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public <T> T getProperty(String name) {
        Object value = this.properties.get(name);
        if (value != null) {
            return (T)value;
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

