/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Requirement;
import com.suncode.plugin.framework.requirements.RequirementResolver;
import com.suncode.plugin.framework.requirements.Resolution;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;

public final class Capabilities
implements RequirementResolver {
    private final Set<PluginCapability> pluginCapabilities;
    private final Set<HostCapability> hostCapabilities;

    @Override
    public Resolution resolve(Requirement requirement) {
        return this.plugin(requirement).orElseGet(() -> this.stateless(requirement).orElseGet(Resolution.Missing::missing));
    }

    private Optional<Resolution> plugin(Requirement requirement) {
        return this.pluginCapabilities.stream().filter(capability -> capability.getId().equals(requirement.getPluginKey())).map(capability -> {
            Version version = capability.getVersion();
            if (!requirement.isSatisfied(version)) {
                return Resolution.VersionMismatch.versionMismatch(version);
            }
            return capability.getState() == Plugin.PluginState.ACTIVE ? Resolution.Running.running() : Resolution.NotActive.notActive();
        }).findFirst();
    }

    private Optional<Resolution> stateless(Requirement requirement) {
        return this.hostCapabilities.stream().filter(capability -> capability.getId().equals(requirement.getPluginKey())).map(capability -> requirement.isSatisfied(capability.getVersion()) ? Resolution.Running.running() : Resolution.VersionMismatch.versionMismatch(capability.getVersion())).findFirst();
    }

    @ConstructorProperties(value={"pluginCapabilities", "hostCapabilities"})
    Capabilities(Set<PluginCapability> pluginCapabilities, Set<HostCapability> hostCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
        this.hostCapabilities = hostCapabilities;
    }

    public static CapabilitiesBuilder builder() {
        return new CapabilitiesBuilder();
    }

    public Set<PluginCapability> getPluginCapabilities() {
        return this.pluginCapabilities;
    }

    public Set<HostCapability> getHostCapabilities() {
        return this.hostCapabilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)o;
        Set<PluginCapability> this$pluginCapabilities = this.getPluginCapabilities();
        Set<PluginCapability> other$pluginCapabilities = other.getPluginCapabilities();
        if (this$pluginCapabilities == null ? other$pluginCapabilities != null : !((Object)this$pluginCapabilities).equals(other$pluginCapabilities)) {
            return false;
        }
        Set<HostCapability> this$hostCapabilities = this.getHostCapabilities();
        Set<HostCapability> other$hostCapabilities = other.getHostCapabilities();
        return !(this$hostCapabilities == null ? other$hostCapabilities != null : !((Object)this$hostCapabilities).equals(other$hostCapabilities));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<PluginCapability> $pluginCapabilities = this.getPluginCapabilities();
        result = result * 59 + ($pluginCapabilities == null ? 43 : ((Object)$pluginCapabilities).hashCode());
        Set<HostCapability> $hostCapabilities = this.getHostCapabilities();
        result = result * 59 + ($hostCapabilities == null ? 43 : ((Object)$hostCapabilities).hashCode());
        return result;
    }

    public String toString() {
        return "Capabilities(pluginCapabilities=" + this.getPluginCapabilities() + ", hostCapabilities=" + this.getHostCapabilities() + ")";
    }

    public static class CapabilitiesBuilder {
        private ArrayList<PluginCapability> pluginCapabilities;
        private ArrayList<HostCapability> hostCapabilities;

        CapabilitiesBuilder() {
        }

        public CapabilitiesBuilder pluginCapability(PluginCapability pluginCapability) {
            if (this.pluginCapabilities == null) {
                this.pluginCapabilities = new ArrayList();
            }
            this.pluginCapabilities.add(pluginCapability);
            return this;
        }

        public CapabilitiesBuilder pluginCapabilities(Collection<? extends PluginCapability> pluginCapabilities) {
            if (pluginCapabilities == null) {
                throw new NullPointerException("pluginCapabilities cannot be null");
            }
            if (this.pluginCapabilities == null) {
                this.pluginCapabilities = new ArrayList();
            }
            this.pluginCapabilities.addAll(pluginCapabilities);
            return this;
        }

        public CapabilitiesBuilder clearPluginCapabilities() {
            if (this.pluginCapabilities != null) {
                this.pluginCapabilities.clear();
            }
            return this;
        }

        public CapabilitiesBuilder hostCapability(HostCapability hostCapability) {
            if (this.hostCapabilities == null) {
                this.hostCapabilities = new ArrayList();
            }
            this.hostCapabilities.add(hostCapability);
            return this;
        }

        public CapabilitiesBuilder hostCapabilities(Collection<? extends HostCapability> hostCapabilities) {
            if (hostCapabilities == null) {
                throw new NullPointerException("hostCapabilities cannot be null");
            }
            if (this.hostCapabilities == null) {
                this.hostCapabilities = new ArrayList();
            }
            this.hostCapabilities.addAll(hostCapabilities);
            return this;
        }

        public CapabilitiesBuilder clearHostCapabilities() {
            if (this.hostCapabilities != null) {
                this.hostCapabilities.clear();
            }
            return this;
        }

        public Capabilities build() {
            Set<HostCapability> hostCapabilities;
            Set<Object> pluginCapabilities;
            switch (this.pluginCapabilities == null ? 0 : this.pluginCapabilities.size()) {
                case 0: {
                    pluginCapabilities = Collections.emptySet();
                    break;
                }
                case 1: {
                    pluginCapabilities = Collections.singleton(this.pluginCapabilities.get(0));
                    break;
                }
                default: {
                    pluginCapabilities = new LinkedHashSet(this.pluginCapabilities.size() < 0x40000000 ? 1 + this.pluginCapabilities.size() + (this.pluginCapabilities.size() - 3) / 3 : Integer.MAX_VALUE);
                    pluginCapabilities.addAll(this.pluginCapabilities);
                    pluginCapabilities = Collections.unmodifiableSet(pluginCapabilities);
                }
            }
            switch (this.hostCapabilities == null ? 0 : this.hostCapabilities.size()) {
                case 0: {
                    hostCapabilities = Collections.emptySet();
                    break;
                }
                case 1: {
                    hostCapabilities = Collections.singleton(this.hostCapabilities.get(0));
                    break;
                }
                default: {
                    hostCapabilities = new LinkedHashSet<HostCapability>(this.hostCapabilities.size() < 0x40000000 ? 1 + this.hostCapabilities.size() + (this.hostCapabilities.size() - 3) / 3 : Integer.MAX_VALUE);
                    hostCapabilities.addAll(this.hostCapabilities);
                    hostCapabilities = Collections.unmodifiableSet(hostCapabilities);
                }
            }
            return new Capabilities(pluginCapabilities, hostCapabilities);
        }

        public String toString() {
            return "Capabilities.CapabilitiesBuilder(pluginCapabilities=" + this.pluginCapabilities + ", hostCapabilities=" + this.hostCapabilities + ")";
        }
    }

    public static final class HostCapability {
        private final Reference reference;

        @ConstructorProperties(value={"reference"})
        public HostCapability(Reference reference) {
            this.reference = reference;
        }

        public Reference getReference() {
            return this.reference;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostCapability)) {
                return false;
            }
            HostCapability other = (HostCapability)o;
            Reference this$reference = this.getReference();
            Reference other$reference = other.getReference();
            return !(this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Reference $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
            return result;
        }

        public String toString() {
            return "Capabilities.HostCapability(reference=" + this.getReference() + ")";
        }

        public Reference withVersion(Version newVersion) {
            return this.getReference().withVersion(newVersion);
        }

        public Reference withVersion(UnaryOperator<Version> versionOp) {
            return this.getReference().withVersion(versionOp);
        }

        public String getId() {
            return this.getReference().getId();
        }

        public Version getVersion() {
            return this.getReference().getVersion();
        }
    }

    public static final class PluginCapability {
        private final Reference reference;
        private final Plugin.PluginState state;

        public static PluginCapability of(Plugin plugin) {
            return new PluginCapability(plugin.getReference(), plugin.getState());
        }

        @ConstructorProperties(value={"reference", "state"})
        public PluginCapability(Reference reference, Plugin.PluginState state) {
            this.reference = reference;
            this.state = state;
        }

        public Reference getReference() {
            return this.reference;
        }

        public Plugin.PluginState getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PluginCapability)) {
                return false;
            }
            PluginCapability other = (PluginCapability)o;
            Reference this$reference = this.getReference();
            Reference other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
                return false;
            }
            Plugin.PluginState this$state = this.getState();
            Plugin.PluginState other$state = other.getState();
            return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Reference $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
            Plugin.PluginState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            return result;
        }

        public String toString() {
            return "Capabilities.PluginCapability(reference=" + this.getReference() + ", state=" + this.getState() + ")";
        }

        public Reference withVersion(Version newVersion) {
            return this.getReference().withVersion(newVersion);
        }

        public Reference withVersion(UnaryOperator<Version> versionOp) {
            return this.getReference().withVersion(versionOp);
        }

        public String getId() {
            return this.getReference().getId();
        }

        public Version getVersion() {
            return this.getReference().getVersion();
        }
    }
}

