/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.plugin.framework.web.support.SectionCondition;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class MenuItem
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(MenuItem.class);
    private final LocalizedMessage label;
    private final List<Condition> conditions;
    private final int order;

    public MenuItem(LocalizedMessage label, List<Condition> conditions, int order) {
        Assert.notNull((Object)label);
        this.label = label;
        this.order = order;
        if (conditions == null) {
            conditions = Collections.emptyList();
        }
        this.conditions = conditions;
    }

    public String getLabel() {
        return this.label.getMessage();
    }

    public LocalizedMessage getLabelMessage() {
        return this.label;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean meetsCondition() {
        for (Condition condition : this.conditions) {
            try {
                if (condition.isFulfilled()) continue;
                return false;
            }
            catch (Exception e) {
                log.error(String.format("Error on checking condition to render \"%s\" menu icon", this.label.getMessage()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean meetsCondition(Section section) {
        Assert.notNull((Object)section);
        for (Condition condition : this.conditions) {
            if (!(condition instanceof SectionCondition ? !((SectionCondition)condition).isFulfilled(section) : !condition.isFulfilled())) continue;
            return false;
        }
        return true;
    }

    public MenuItem applyConditions(Section section) {
        if (this.meetsCondition(section)) {
            return this;
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }
}

