/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.plannedtask.administration.structure.ImportStructureUtils;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.GroupMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.OrgUnitMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.PositionMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.UserMappings;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.List;

@ScheduledTask
@ScheduledTaskScript(value="scripts/import-organizational-structure-form.js")
public class ImportOrgStructureTask {
    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("import-organizational-structure-task")).name("importOrganizationalStructure")).description("importOrganizationalStructure")).parameter().id("path_to_excel_file").name("path_to_excel_file").description("path_to_excel_file").type((Type)Types.STRING).create()).parameter().id("read_mode").name("read_mode").description("read_mode_desc").type((Type)Types.STRING).create()).parameter().id("unused_users").name("unused_users").description("unused_users_desc").type((Type)Types.STRING).create()).parameter().id("assign_users_tasks").name("assign_users_tasks").description("assign_users_tasks_desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="path_to_excel_file") String path, @Param(value="read_mode") String mode, @Param(value="unused_users") String unusedUsersHandleType, @Param(value="assign_users_tasks") String assignmentUsers) throws Exception {
        ImportStructureUtils.checkFileExist(path);
        List<ImportSheetDefinition> importSheetDefinitions = this.buildDefinitions();
        StructureData data = ImportStructureUtils.importDataFromXls(importSheetDefinitions, path);
        StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
        validator.validateStructure(data, mode);
        ImportStructureUtils.exportDataToDatabase(data, mode, unusedUsersHandleType, assignmentUsers);
    }

    private List<ImportSheetDefinition> buildDefinitions() {
        ArrayList<ImportSheetDefinition> definitions = new ArrayList<ImportSheetDefinition>();
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("U\u017cytkownicy", UserMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Grupy", GroupMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Stanowiska", PositionMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Jednostki organizacyjne", OrgUnitMappings.getInstance()));
        return definitions;
    }
}

