/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.servlet.extension.CUF.StoreDocumentBytes;
import com.plusmpm.util.Tools;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

public class ShowDocToolTip
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(StoreDocumentBytes.class);

    public void destroy() {
        super.destroy();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"********** ShowDocToolTip Servlet **********");
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ServletOutputStream servletOutputStream = null;
        ByteArrayOutputStream baos = null;
        File fFile = null;
        String sFileName = null;
        byte[] fileBytes = null;
        try {
            HttpSession httpSession = request.getSession(false);
            String sBrowser = request.getHeader("user-agent");
            String sUSerName = (String)httpSession.getAttribute("username");
            String sFileId = request.getParameter("fileId");
            String sPageNum = request.getParameter("pageNum");
            String sWidth = request.getParameter("width");
            String sHeight = request.getParameter("height");
            int iPageNum = 1;
            int iWidth = 200;
            int iHeight = 200;
            if (Tools.isNullOrEmpty((String)sUSerName)) {
                throw new CUFException("Brak nazwy uzytkownika w atrybucie sesji");
            }
            try {
                iPageNum = Integer.parseInt(sPageNum);
                if (iPageNum < 1) {
                    iPageNum = 1;
                }
            }
            catch (NumberFormatException e) {
                iPageNum = 1;
            }
            try {
                iWidth = Integer.parseInt(sWidth);
                if (iWidth < 1) {
                    iWidth = 200;
                }
            }
            catch (NumberFormatException e) {
                iWidth = 200;
            }
            try {
                iHeight = Integer.parseInt(sHeight);
                if (iHeight < 1) {
                    iHeight = 200;
                }
            }
            catch (NumberFormatException e) {
                iHeight = 200;
            }
            if (Tools.isNullOrEmpty((String)sFileId)) {
                throw new CUFException("Brak identyfikatora pliku");
            }
            FilesManager filesManager = new FilesManager();
            Files files = filesManager.GetFile(Long.valueOf(Long.parseLong(sFileId)));
            if (files == null) {
                throw new CUFException("Plik o identyfikatorze " + sFileId + " nie istnieje w systemie");
            }
            Object orgFileName = files.getOrg_name();
            String sFilePath = files.getPath();
            sFileName = sFilePath.endsWith(File.separator) ? files.getPath() + files.getName() : files.getPath() + File.separator + files.getName();
            fFile = new File(sFileName);
            if (!fFile.exists() || !fFile.canRead()) {
                throw new CUFException("Plik: " + sFileName + " (id: " + sFileId + " ) nie istnieje lub nie mozna go odczytac.");
            }
            String sMimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(fFile);
            String sFileExt = ((String)orgFileName).substring(((String)orgFileName).lastIndexOf(".") + 1, ((String)orgFileName).length());
            servletOutputStream = response.getOutputStream();
            baos = new ByteArrayOutputStream();
            if (sFileExt.equalsIgnoreCase("pdf")) {
                fileInputStream = new FileInputStream(fFile);
                fileBytes = IOUtils.toByteArray((InputStream)fileInputStream);
                ShowDocToolTip.handlePdfPage(fileBytes, iPageNum, servletOutputStream, response, iWidth, iHeight);
            } else {
                if (sFileExt.equalsIgnoreCase("html") || sFileExt.equalsIgnoreCase("htm") || sFileExt.equalsIgnoreCase("txt") || sFileExt.equalsIgnoreCase("log") || sFileExt.equalsIgnoreCase("java") || sFileExt.equalsIgnoreCase("php") || sFileExt.equalsIgnoreCase("ini") || sFileExt.equalsIgnoreCase("jpg") || sFileExt.equalsIgnoreCase("jpeg") || sFileExt.equalsIgnoreCase("png") || sFileExt.equalsIgnoreCase("gif") || sFileExt.equalsIgnoreCase("xml") || sFileExt.equalsIgnoreCase("docx")) {
                    Document document = null;
                    try {
                        document = new Document(PageSize.A4, 0.0f, 0.0f, 0.0f, 0.0f);
                        PdfWriter.getInstance((Document)document, (OutputStream)baos);
                        document.open();
                        if (sFileExt.equalsIgnoreCase("html") || sFileExt.equalsIgnoreCase("htm")) {
                            fileInputStream = new FileInputStream(fFile);
                            ArrayList objectsList = HTMLWorker.parseToList((Reader)new InputStreamReader(fileInputStream), null);
                            for (Element o : objectsList) {
                                document.add(o);
                            }
                            if (document.isOpen()) {
                                document.close();
                            }
                        } else if (sFileExt.equalsIgnoreCase("txt") || sFileExt.equalsIgnoreCase("ini") || sFileExt.equalsIgnoreCase("log") || sFileExt.equalsIgnoreCase("java") || sFileExt.equalsIgnoreCase("php")) {
                            baseFont = BaseFont.createFont((String)"Times-Roman", (String)"Cp1250", (boolean)true);
                            font = new Font(baseFont, 20.0f, 0, new Color(0, 0, 0));
                            fileInputStream = new FileInputStream(fFile);
                            byte[] bytes = IOUtils.toByteArray((InputStream)fileInputStream);
                            String textFileContent = new String(bytes, "UTF-8");
                            Paragraph paragraph = new Paragraph();
                            Phrase phrase = new Phrase(textFileContent, font);
                            paragraph.add((Element)phrase);
                            document.add((Element)paragraph);
                            document.close();
                        } else if (sFileExt.equalsIgnoreCase("jpg") || sFileExt.equalsIgnoreCase("jpeg") || sFileExt.equalsIgnoreCase("png") || sFileExt.equalsIgnoreCase("gif")) {
                            Image image = Image.getInstance((String)fFile.getAbsolutePath());
                            image.scaleToFit(document.getPageSize().getWidth(), document.getPageSize().getHeight());
                            document.add((Element)image);
                            document.close();
                        } else if (sFileExt.equalsIgnoreCase("xml")) {
                            baseFont = BaseFont.createFont((String)"Times-Roman", (String)"Cp1250", (boolean)true);
                            font = new Font(baseFont, 20.0f, 0, new Color(0, 0, 0));
                            String xmlFileContent = CUFTools.convertXMLFileToStringFromFilePath(fFile.getAbsolutePath());
                            Paragraph paragraph = new Paragraph();
                            Phrase phrase = new Phrase(xmlFileContent, font);
                            paragraph.add((Element)phrase);
                            document.add((Element)paragraph);
                            document.close();
                        } else if (sFileExt.equalsIgnoreCase("docx")) {
                            try {
                                WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)fFile);
                                Conversion pdfConversion = new Conversion(wordMLPackage);
                                BestMatchingMapper fontMapper = new BestMatchingMapper();
                                wordMLPackage.setFontMapper((Mapper)fontMapper);
                                pdfConversion.output((OutputStream)baos, null);
                            }
                            catch (Throwable t) {
                                throw new CUFException("Brak bibliotek do DOCX");
                            }
                        }
                        fileBytes = baos.toByteArray();
                        ShowDocToolTip.handlePdfPage(fileBytes, iPageNum, servletOutputStream, response, iWidth, iHeight);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        try {
                            if (document != null && document.isOpen()) {
                                document.close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                fileBytes = ((String)orgFileName).getBytes("UTF-8");
                response.setContentLength(fileBytes.length);
                servletOutputStream.write(fileBytes);
            }
            if (sBrowser.indexOf("Mac OS X") > -1 || sBrowser.indexOf("Macintosh") > -1) {
                response.setContentType(sMimeType);
                response.addHeader("Content-Disposition", "filename=" + (String)orgFileName);
            } else {
                response.setContentType(sMimeType);
                String usAsciiFileName = new String(((String)orgFileName).getBytes(), "US-ASCII");
                if (!usAsciiFileName.equals(orgFileName)) {
                    String userAgent = request.getHeader("User-Agent");
                    Object encodedFileName = null;
                    encodedFileName = userAgent.contains("MSIE") || userAgent.contains("Opera") ? URIUtil.encodeQuery((String)orgFileName, (String)"UTF-8") : "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])((String)orgFileName).getBytes("UTF-8")), "UTF-8") + "?=";
                    orgFileName = "\"" + (String)encodedFileName + "\"";
                } else {
                    orgFileName = "\"" + (String)orgFileName + "\"";
                }
                response.setHeader("Content-Disposition", "filename=" + (String)orgFileName);
            }
            servletOutputStream.flush();
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private static void handlePdfPage(byte[] fileBytes, int iPageNum, ServletOutputStream servletOutputStream, HttpServletResponse response, int iWidth, int iHeight) throws Exception {
        ByteArrayOutputStream baos = null;
        RandomAccessFileOrArray pdf = null;
        try {
            pdf = new RandomAccessFileOrArray(fileBytes);
            PDFFile pdfFile = new PDFFile(pdf.getNioByteBuffer());
            int iNoOfPages = pdfFile.getNumPages();
            if (iNoOfPages < iPageNum) {
                iPageNum = iNoOfPages;
            }
            PDFPage pdfPage = pdfFile.getPage(iPageNum);
            Rectangle2D pdfBox = pdfPage.getBBox();
            Rectangle rectangle = new Rectangle(0, 0, (int)pdfBox.getWidth(), (int)pdfBox.getHeight());
            BufferedImage image = (BufferedImage)pdfPage.getImage(iWidth, iHeight, (Rectangle2D)rectangle, null, true, true);
            Graphics2D g2d = (Graphics2D)image.getGraphics();
            g2d.setBackground(Color.WHITE);
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            servletOutputStream.write(imageBytes);
            response.setContentLength(imageBytes.length);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (pdf != null && pdf.isOpen()) {
                    pdf.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

