/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.msproject;

import com.plusmpm.CUF.util.extension.msproject.MSPServiceStub;
import com.plusmpm.CUF.util.extension.msproject.MSPTask;
import com.plusmpm.CUF.util.extension.msproject.MSProjectBuilder;
import com.plusmpm.CUF.util.extension.msproject.MSProjectException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;

public class MPPBuilder
extends MSProjectBuilder {
    private static Logger log = Logger.getLogger(MPPBuilder.class);

    @Override
    public InputStream buildProject(List<MSPTask> tasks) throws MSProjectException {
        log.info((Object)"Tworzenie pliku MPP");
        try {
            MSPServiceStub service = new MSPServiceStub();
            log.info((Object)"Stworzono web service");
            MSPServiceStub.ArrayOfMSPTaskDto dtoTasks = new MSPServiceStub.ArrayOfMSPTaskDto();
            for (MSPTask mspTask : tasks) {
                MSPServiceStub.MSPTaskDto dtoTask = this.buildTaskDto(mspTask);
                dtoTasks.addMSPTaskDto(dtoTask);
            }
            MSPServiceStub.MSPProjectDto project = new MSPServiceStub.MSPProjectDto();
            project.setTasks(dtoTasks);
            MSPServiceStub.CreateProject cp = new MSPServiceStub.CreateProject();
            cp.setProject(project);
            log.info((Object)"Utowrzono struktur\u0119 projektu. Wywo\u0142uje metod\u0119 creatProject");
            MSPServiceStub.CreateProjectResponse cpr = service.createProject(cp);
            log.info((Object)"Wywo\u0142anie servie'u zako\u0144czono powodzeniem");
            DataHandler dh = cpr.getCreateProjectResult();
            InputStream is = dh.getInputStream();
            log.info((Object)"Zako\u0144czono tworzenie pliku MPP");
            return is;
        }
        catch (AxisFault e) {
            log.error((Object)"B\u0142\u0105d podczas tworzenia web service'u ", (Throwable)e);
            throw new MSProjectException("B\u0142\u0105d podczas tworzenia web service'u ", e);
        }
        catch (RemoteException e) {
            log.error((Object)"B\u0142\u0105d podczas generowania pliku", (Throwable)e);
            throw new MSProjectException("B\u0142\u0105d podczas generowania pliku", e);
        }
        catch (IOException e) {
            log.error((Object)"B\u0142\u0105d podczas odczytu strumienia danych", (Throwable)e);
            throw new MSProjectException("B\u0142\u0105d podczas odczytu strumienia danych", e);
        }
    }

    private MSPServiceStub.MSPTaskDto buildTaskDto(MSPTask mspTask) {
        MSPServiceStub.MSPTaskDto dtoTask = new MSPServiceStub.MSPTaskDto();
        dtoTask.setName(mspTask.getName());
        dtoTask.setPercentageComplete(mspTask.getPercentageComplete());
        dtoTask.setResourceName(mspTask.getResourceName());
        Calendar start = Calendar.getInstance();
        start.setTime(mspTask.getStartDate());
        Calendar end = Calendar.getInstance();
        end.setTime(mspTask.getEndDate());
        dtoTask.setStartDate(start);
        dtoTask.setEndDate(end);
        this.addChildren(dtoTask, mspTask);
        return dtoTask;
    }

    private void addChildren(MSPServiceStub.MSPTaskDto dtoTask, MSPTask mspTask) {
        if (mspTask.getChildren() != null && !mspTask.getChildren().isEmpty()) {
            MSPServiceStub.ArrayOfMSPTaskDto dtoTasks = new MSPServiceStub.ArrayOfMSPTaskDto();
            for (MSPTask task : mspTask.getChildren()) {
                MSPServiceStub.MSPTaskDto child = this.buildTaskDto(task);
                dtoTasks.addMSPTaskDto(child);
            }
            dtoTask.setChildren(dtoTasks);
        }
    }
}

