/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.archive.internal;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.cuf.archive.ExtDocumentClassService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ExtDocumentClassServiceImpl
implements ExtDocumentClassService {
    private static final Logger log = Logger.getLogger(ExtDocumentClassServiceImpl.class);
    private DBManagement dbm = new DBManagement();

    @Override
    public Long getDocumentClassId(String documentClassName) {
        DocClassTable dct = this.dbm.getDocClassByName(documentClassName);
        return dct.getId();
    }

    @Override
    public Map<String, IndexTable> getIndexNameIdMap(Long documentClassId) {
        List<IndexTable> destIndexes = this.getIndexesForDocumentClass(documentClassId);
        Map<String, IndexTable> destNameIdMap = this.buildNameIdxMap(destIndexes);
        return destNameIdMap;
    }

    @Override
    public Map<Long, IndexTable> getIndexIdNameMap(Long documentClassId) {
        List<IndexTable> destIndexes = this.getIndexesForDocumentClass(documentClassId);
        Map<Long, IndexTable> destIdIdxMap = this.buildIdIdxMap(destIndexes);
        return destIdIdxMap;
    }

    @Override
    public List<IndexTable> getIndexesForDocumentClass(Long documentClassId) {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(IndexTable.class);
            crit.add((Criterion)Restrictions.eq((String)"docclassId", (Object)documentClassId));
            List indexes = crit.list();
            tx.commit();
            List list = indexes;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private Map<String, IndexTable> buildNameIdxMap(List<IndexTable> destIndexes) {
        HashMap<String, IndexTable> nameIdxMap = new HashMap<String, IndexTable>();
        for (IndexTable indexTable : destIndexes) {
            nameIdxMap.put(indexTable.getIndexName(), indexTable);
        }
        return nameIdxMap;
    }

    private Map<Long, IndexTable> buildIdIdxMap(List<IndexTable> destIndexes) {
        HashMap<Long, IndexTable> nameIdxMap = new HashMap<Long, IndexTable>();
        for (IndexTable indexTable : destIndexes) {
            nameIdxMap.put(indexTable.getId(), indexTable);
        }
        return nameIdxMap;
    }

    @Override
    public Map<String, Long> getIndexNameIdMap(Long documentClassId, List<String> asList) {
        List<IndexTable> destIndexes = this.getIndexesForDocumentClass(documentClassId);
        HashMap<String, Long> nameIdxMap = new HashMap<String, Long>();
        for (IndexTable indexTable : destIndexes) {
            nameIdxMap.put(indexTable.getIndexName(), indexTable.getId());
        }
        return nameIdxMap;
    }

    @Override
    public Map<Long, String> getIndexIdNameMap(Long documentClassId, List<String> asList) {
        List<IndexTable> destIndexes = this.getIndexesForDocumentClass(documentClassId);
        HashMap<Long, String> nameIdxMap = new HashMap<Long, String>();
        for (IndexTable indexTable : destIndexes) {
            nameIdxMap.put(indexTable.getId(), indexTable.getIndexName());
        }
        return nameIdxMap;
    }
}

