/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

@Deprecated(since="4.2", forRemoval=true)
public class ImportProcessesProtection
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportProcessesProtection.class);

    @AdvancedTask(name="ImportProcessesProtectionFromXLS", description="ImportProcessesProtectionFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportProcessesProtectionFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportProcessesProtectionFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Ochrona proces\u00f3w");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Ochrona proces\u00f3w w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 7; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z ochrona procesow");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                    String procDefId = "";
                    String groupName = sheet.getCell(((Integer)header.get("Nazwa grupy")).intValue(), i).getContents();
                    String userName = sheet.getCell(((Integer)header.get("Nazwa u\u017cytkownika")).intValue(), i).getContents();
                    String recourceId = "";
                    boolean isGroup = false;
                    String view = sheet.getCell(((Integer)header.get("Podgl\u0105d")).intValue(), i).getContents();
                    String create = sheet.getCell(((Integer)header.get("Tworzenie")).intValue(), i).getContents();
                    String delete = sheet.getCell(((Integer)header.get("Usuwanie")).intValue(), i).getContents();
                    String stats = sheet.getCell(((Integer)header.get("Statystyki")).intValue(), i).getContents();
                    if (Tools.isNullOrEmpty((String)processName)) {
                        throw new CUFException("Brak nazwy procesu w wierszu numer " + i + " w pliku " + sXLSPath);
                    }
                    procDefId = CUFTools.getProcDefIdForProcessName(processName);
                    if (Tools.isNullOrEmpty((String)procDefId)) {
                        throw new CUFException("W systemie nie istnieje proces o nazwie " + processName);
                    }
                    if (Tools.isNullOrEmpty((String)userName) && Tools.isNullOrEmpty((String)groupName)) {
                        throw new CUFException("Podaj nazwe grupy lub nazwe uzytkownika w wierszu numer " + i + " w pliku " + sXLSPath);
                    }
                    if (!Tools.isNullOrEmpty((String)userName) && !Tools.isNullOrEmpty((String)groupName)) {
                        throw new CUFException("Podaj tylko nazwe grupy lub tylko nazwe uzytkownika w wierszu numer " + i + " w pliku " + sXLSPath);
                    }
                    if (!Tools.isNullOrEmpty((String)groupName)) {
                        if (!uga.doesGroupExist(groupName)) {
                            throw new CUFException("Grupa " + groupName + " nie istnieje w systemie");
                        }
                        isGroup = true;
                        recourceId = groupName;
                    }
                    if (!Tools.isNullOrEmpty((String)userName)) {
                        if (!uga.doesUserExist(userName)) {
                            throw new CUFException("Uzytkownik " + userName + " nie istnieje w systemie");
                        }
                        isGroup = false;
                        recourceId = userName;
                    }
                    if (view != null && view.equalsIgnoreCase("tak")) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)procDefId).build(), (String)recourceId, (boolean)isGroup);
                        log.info((Object)(recourceId + " otrzymal prawo do podgladu procesow o nazwie " + processName));
                    }
                    if (create != null && create.equalsIgnoreCase("tak")) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)procDefId).build(), (String)recourceId, (boolean)isGroup);
                        log.info((Object)(recourceId + " otrzymal prawo do tworzenia procesow o nazwie " + processName));
                    }
                    if (delete != null && delete.equalsIgnoreCase("tak")) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)procDefId).build(), (String)recourceId, (boolean)isGroup);
                        log.info((Object)(recourceId + " otrzymal prawo do usuwania procesow o nazwie " + processName));
                    }
                    if (stats == null || !stats.equalsIgnoreCase("tak")) continue;
                    Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().stats().custom((Object)procDefId).build(), (String)recourceId, (boolean)isGroup);
                    log.info((Object)(recourceId + " otrzymal prawo do statystyk procesow o nazwie " + processName));
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import ochrony procesow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportProcessesProtectionFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

