/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.search.hibernate;

import com.suncode.cuf.search.hibernate.HibernateFilter;
import com.suncode.cuf.search.hibernate.HibernateFinder;
import com.suncode.cuf.search.hibernate.HibernateQueryDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.QueryExecutor;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HibernateFinderImpl
implements HibernateFinder {
    @Autowired
    private QueryExecutor qe;
    @Autowired
    private SessionFactory sf;

    @Override
    public <T> List<T> find(HibernateQueryDefinition filterDefinition) {
        DetachedCriteria dc = this.buildFilteredCriteria(filterDefinition);
        this.addJoins(dc, filterDefinition.getJoins());
        this.addSorters(dc, filterDefinition.getSorters());
        return this.qe.findByCriteria(dc, filterDefinition.getStart(), filterDefinition.getLimit());
    }

    private void addAdditionalOptions(DetachedCriteria dc, HibernateQueryDefinition filterDefinition) {
        if (filterDefinition.isDistinct()) {
            dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        }
    }

    private void addSorters(DetachedCriteria dc, List<Sorter> sorters) {
        for (Sorter sorter : sorters) {
            if (sorter.getDirection() == SortDirection.DESC) {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
                continue;
            }
            dc.addOrder(Order.asc((String)sorter.getProperty()));
        }
    }

    private void addJoins(DetachedCriteria dc, List<String> joins) {
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
    }

    @Override
    public <T> CountedResult<T> findCounted(HibernateQueryDefinition filterDefinition) {
        List<T> list = this.find(filterDefinition);
        DetachedCriteria count = this.buildFilteredCriteria(filterDefinition);
        this.addCountProjection(count, filterDefinition);
        Long total = Long.valueOf(count.getExecutableCriteria(this.qe.getSession()).uniqueResult().toString());
        CountedResult data = new CountedResult(total.longValue(), list);
        return data;
    }

    private void addCountProjection(DetachedCriteria count, HibernateQueryDefinition filterDefinition) {
        if (filterDefinition.isDistinct()) {
            ClassMetadata cmd = this.sf.getClassMetadata(filterDefinition.getType());
            String idProperty = cmd.getIdentifierPropertyName();
            count.setProjection((Projection)Projections.countDistinct((String)idProperty));
        } else {
            count.setProjection(Projections.rowCount());
        }
    }

    private DetachedCriteria buildFilteredCriteria(HibernateQueryDefinition filterDefinition) {
        DetachedCriteria dc = DetachedCriteria.forClass(filterDefinition.getType());
        this.addAliases(dc, filterDefinition.getAliases());
        for (HibernateFilter filter : filterDefinition.getFilters()) {
            dc.add(filter.buildCriterion());
        }
        this.addAdditionalOptions(dc, filterDefinition);
        return dc;
    }

    private void addAliases(DetachedCriteria dc, Map<String, String> aliases) {
        for (String key : aliases.keySet()) {
            dc.createAlias(key, aliases.get(key));
        }
    }
}

