/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.IndexData;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GetDocumentIndexesInfo
extends HttpServlet {
    public static Logger log = Logger.getLogger(GetDocumentIndexesInfo.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* GetDocumentIndexesInfo Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        ArrayList records = null;
        boolean bSuccess = false;
        String answerMessage = "-1";
        DBManagement dbm = new DBManagement();
        FilesManager filesManager = new FilesManager();
        Files file = null;
        List indexes = null;
        Long lFileId = null;
        String sDocClassName = "";
        try {
            records = new ArrayList();
            String sFileId = request.getParameter("fileId");
            try {
                lFileId = Long.parseLong(sFileId);
            }
            catch (NumberFormatException e) {
                throw new CUFException("Podany identyfikator pliku nie jest wartoscia liczbowa");
            }
            file = filesManager.GetFile(lFileId);
            if (file == null) {
                throw new CUFException("Brak pliku o identyfikatorze " + sFileId);
            }
            sDocClassName = ArchiveServices.GetDocClassNameForDocument(sFileId);
            if (Tools.isNullOrEmpty((String)sDocClassName)) {
                throw new CUFException("Dokument o identyfikatorze " + sFileId + " nie jest w zadnej klasie dokumentow");
            }
            DocClassTable docClassTable = dbm.getDocClassByName(sDocClassName);
            Long lDocClassId = docClassTable.getId();
            String sDocClassId = lDocClassId.toString();
            DocumentData documentData = DBManagement.GetDocumentByFileId((String)sDocClassId, (String)sFileId);
            if (documentData == null) {
                throw new CUFException("Brak informacji o indeksach dokuemntu o identyfikatorze " + sFileId);
            }
            indexes = documentData.getAlIndecies();
            if (indexes != null && indexes.size() > 0) {
                for (IndexData index : indexes) {
                    HashMap<String, String> indexInfo = new HashMap<String, String>();
                    long indexId = index.getId();
                    IndexTable indexTable = DBManagement.getIndex((String)String.valueOf(indexId));
                    String indexName = indexTable.getIndexName();
                    String indexType = indexTable.getIndexType();
                    String indexValue = index.getValue();
                    if (indexName == null) {
                        indexName = "";
                    }
                    if (indexType == null) {
                        indexType = "string";
                    }
                    if (indexValue == null) {
                        indexValue = "";
                    }
                    indexInfo.put("name", indexName);
                    indexInfo.put("type", indexType);
                    indexInfo.put("value", indexValue);
                    if (indexType.equalsIgnoreCase("list")) {
                        indexInfo.put("listValues", indexTable.getIndexValues());
                    }
                    records.add(indexInfo);
                }
            }
            bSuccess = true;
            answerMessage = "Pobrano informacje o indeksach";
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d odczytu indeks\u00f3w dokumentu.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

