/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DynamicTableStorageDelete
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageDelete.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageDelete Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        boolean bSuccess = false;
        Object answerMessage = "";
        try {
            String storageName = request.getParameter("storageName");
            String owner = request.getParameter("owner");
            String tabTitle = request.getParameter("tabTitle");
            if (Tools.isNullOrEmpty((String)storageName)) {
                throw new CUFException("Brak zestawu danych o nazwie " + storageName);
            }
            if (Tools.isNullOrEmpty((String)owner)) {
                throw new CUFException("Nie zidentyfikowano w\u0142a\u015bciciela zestawu. Nie mo\u017cna usun\u0105\u0107 zestawu danych o nazwie " + storageName + ".");
            }
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mo\u017cna usun\u0105\u0107 zestawu danych o nazwie " + storageName + ".");
            }
            List<DynamicTableStorage> storage = DynamicTableStorageManager.getDynamicTableStorageByNameAndUser(storageName, owner, tabTitle);
            if (storage == null || storage.size() == 0) {
                throw new CUFException("Zestaw danych o nazwie " + storageName + " nie istnieje.");
            }
            log.info((Object)("Rozpoznano zestaw danych o nazwie " + storageName + ". Usuwanie rekordow"));
            for (DynamicTableStorage oneData : storage) {
                DynamicTableStorageManager.delete(oneData);
            }
            bSuccess = true;
            answerMessage = "Usuni\u0119to zestaw danych o nazwie " + storageName + ".";
            log.info((Object)("Usunieto zestaw danych o nazwie " + storageName));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn(answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d podczas usuwania zestawu danych.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage((String)answerMessage);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

