/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.hibernate;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.cuf.sql.query.DMLQuery;
import com.suncode.cuf.sql.query.ParamValue;
import com.suncode.cuf.sql.query.QueryExecutor;
import com.suncode.cuf.sql.query.SelectQuery;
import com.suncode.cuf.sql.query.exception.NoCountQueryDefined;
import com.suncode.cuf.sql.query.type.SqlType;
import com.suncode.pwfl.search.CountedResult;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class HibernateQueryExecutor
implements QueryExecutor {
    private static final Logger log = Logger.getLogger(HibernateQueryExecutor.class);
    private SessionFactory sessionFactory;

    @Override
    public int executeUpdate(DMLQuery query) {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            int result = this.executeUpdate(query, hs);
            tx.commit();
            int n = result;
            return n;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public int executeUpdate(DMLQuery query, Session hs) {
        NativeQuery sql = hs.createSQLQuery(query.getQuery());
        this.setParameters((SQLQuery)sql, query.getParameters());
        int result = sql.executeUpdate();
        return result;
    }

    @Override
    public List<Map<String, Object>> list(SelectQuery query) {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            List<Map<String, Object>> result = this.list(query, hs);
            tx.commit();
            List<Map<String, Object>> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<Map<String, Object>> list(SelectQuery query, Session hs) {
        return this.listWithLimit(query, null, null, hs);
    }

    @Override
    public CountedResult<Map<String, Object>> list(SelectQuery query, Integer start, Integer limit) {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            CountedResult<Map<String, Object>> result = this.list(query, start, limit, hs);
            tx.commit();
            CountedResult<Map<String, Object>> countedResult = result;
            return countedResult;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public CountedResult<Map<String, Object>> list(SelectQuery query, Integer start, Integer limit, Session hs) {
        List<Map<String, Object>> data = this.listWithLimit(query, start, limit, hs);
        Long total = this.getTotal(query, hs);
        return new CountedResult(total.longValue(), data);
    }

    private Long getTotal(SelectQuery query, Session hs) {
        if (StringUtils.isBlank((String)query.getCountQuery())) {
            throw new NoCountQueryDefined();
        }
        NativeQuery sql = hs.createSQLQuery(query.getCountQuery());
        this.setParameters((SQLQuery)sql, query.getParameters());
        Long total = Long.valueOf(sql.uniqueResult().toString());
        return total;
    }

    private List<Map<String, Object>> listWithLimit(SelectQuery query, Integer start, Integer limit, Session hs) {
        NativeQuery sql = hs.createSQLQuery(query.getQuery());
        this.setParameters((SQLQuery)sql, query.getParameters());
        this.setScalars((SQLQuery)sql, query.getScalars());
        if (start != null) {
            sql.setFirstResult(start.intValue());
        }
        if (limit != null) {
            sql.setMaxResults(limit.intValue());
        }
        sql.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List result = sql.list();
        return result;
    }

    private void setParameters(SQLQuery sql, List<ParamValue> parameters) {
        for (ParamValue param : parameters) {
            param.getType().setHibernateParam(sql, param);
        }
    }

    private void setScalars(SQLQuery sql, Map<String, SqlType> scalars) {
        for (String key : scalars.keySet()) {
            sql.addScalar(key, scalars.get(key).getHibernateType());
        }
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = HibernateUtil.getSessionFactory();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

