/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.CellView;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class LoadDynamicTableDataToXls
extends HttpServlet {
    public static Logger log = Logger.getLogger(LoadDynamicTableDataToXls.class);
    private static final long serialVersionUID = 1L;
    public static Map<String, ByteArrayOutputStream> bosMap = new HashMap<String, ByteArrayOutputStream>();

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* LoadDynamicTableDataToXls Servlet ********************");
        String strData = request.getParameter("strData");
        String action = request.getParameter("action");
        String processid = request.getParameter("processid");
        String docName = request.getParameter("docName");
        log.info((Object)"Dane z tabeli: ".concat(strData));
        strData = URLDecoder.decode(strData, "UTF-8");
        log.info((Object)"Dane z tabeli odkodowane: ".concat(strData));
        log.info((Object)"Action: ".concat(action));
        log.info((Object)"Processid: ".concat(processid));
        log.info((Object)"docName: ".concat(docName));
        if (action.compareTo("create") == 0) {
            log.info((Object)"Tworzenie dokumentu ".concat(docName));
            PrintWriter printWriter = null;
            JsonStore jsonStore = null;
            GsonCustomUtils gsonCustomUtils = null;
            boolean bSuccess = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                WritableWorkbook w = Workbook.createWorkbook((OutputStream)bos);
                WritableSheet s = w.createSheet(docName, 0);
                WritableFont times12font = new WritableFont(WritableFont.TIMES, 12);
                times12font.setBoldStyle(WritableFont.BOLD);
                times12font.setColour(Colour.WHITE);
                WritableCellFormat times12format = new WritableCellFormat(times12font);
                times12format.setAlignment(Alignment.CENTRE);
                times12format.setBackground(Colour.BLUE);
                times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
                CellView cellView = new CellView();
                cellView.setAutosize(true);
                String[] rows = strData.split("<row>");
                for (int i = 0; i < rows.length; ++i) {
                    String[] colsRec = rows[i].split("<col>");
                    for (int j = 0; j < colsRec.length; ++j) {
                        if (i == 0) {
                            s.addCell((WritableCell)new Label(j, i, colsRec[j], (CellFormat)times12format));
                            s.setColumnView(j, cellView);
                            continue;
                        }
                        s.addCell((WritableCell)new Label(j, i, colsRec[j]));
                    }
                }
                w.write();
                w.close();
                bosMap.put(processid, bos);
                bSuccess = true;
            }
            catch (Exception e) {
                throw new ServletException("Exception in Excel gen Servlet", (Throwable)e);
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    jsonStore = new JsonStore();
                    jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                    gsonCustomUtils = new GsonCustomUtils();
                    String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                    response.setContentType("application/json;charset=UTF-8");
                    printWriter = response.getWriter();
                    printWriter.print(sJsonData);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        if (action.compareTo("show") == 0) {
            log.info((Object)"Pobieranie dokumentu ".concat(docName));
            ByteArrayOutputStream bos = bosMap.get(processid);
            if (bos != null) {
                ServletOutputStream op = null;
                try {
                    bosMap.remove(processid);
                    op = response.getOutputStream();
                    if (Tools.isNullOrEmpty((String)docName) || docName.equalsIgnoreCase("undefined")) {
                        docName = "Dane z tabeli dynamicznej";
                    }
                    response.setContentType("application/ms-excel");
                    response.setContentLength(bos.size());
                    response.setHeader("Content-Disposition", "attachment; filename=\"".concat(docName).concat(".xls\""));
                    byte[] bosArray = bos.toByteArray();
                    for (int i = 0; i < bos.size(); ++i) {
                        op.write((int)bosArray[i]);
                    }
                    op.flush();
                }
                catch (Exception e) {
                    throw new ServletException("Exception in Excel gen Servlet", (Throwable)e);
                }
                finally {
                    try {
                        if (bos != null) {
                            bos.close();
                            bosMap.remove(processid);
                        }
                        if (op != null) {
                            op.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

