/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.storage;

import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class DynamicTableStorageManager {
    public static void save(DynamicTableStorage oneData) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.save((Object)oneData);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void update(DynamicTableStorage oneData) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)oneData);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void delete(DynamicTableStorage oneData) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)oneData);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public void deleteAll() throws HibernateException, Exception {
        List<DynamicTableStorage> AllList = DynamicTableStorageManager.getAll();
        try {
            for (DynamicTableStorage oneData : AllList) {
                DynamicTableStorageManager.delete(oneData);
            }
        }
        catch (HibernateException he) {
            throw he;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static List<DynamicTableStorage> getAll() throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createCriteria(DynamicTableStorage.class).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<String> getAllStoragesNames(boolean limitByUser, String username, String tabTitle) throws HibernateException, Exception {
        List storagesNames = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            if (limitByUser) {
                criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            }
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"storageName"))).addOrder(Property.forName((String)"storageName").asc());
            storagesNames = criteria.list();
            transaction.commit();
            List list = storagesNames;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<DynamicTableStorage> getDynamicTableStorageByNameAndUser(String storageName, String username, String tabTitle) throws HibernateException, Exception {
        List results = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"storageName", (Object)storageName));
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.addOrder(Property.forName((String)"rowNumber").asc());
            results = criteria.list();
            transaction.commit();
            List list = results;
            return list;
        }
        catch (HibernateException e) {
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<DynamicTableStorage> getDynamicTableStorageRecord(String storageName, String username, String tabTitle, int row) throws HibernateException, Exception {
        List results = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"storageName", (Object)storageName));
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.add((Criterion)Restrictions.eq((String)"rowNumber", (Object)row));
            results = criteria.list();
            transaction.commit();
            List list = results;
            return list;
        }
        catch (HibernateException e) {
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static boolean exists(String storageName, String username, String tabTitle) throws HibernateException, Exception {
        boolean bExists = false;
        List<DynamicTableStorage> results = DynamicTableStorageManager.getDynamicTableStorageByNameAndUser(storageName, username, tabTitle);
        if (results != null && results.size() > 0) {
            bExists = true;
        }
        return bExists;
    }

    public static int getDynamicTableStorageNoOfRecords(String storageName, String username, String tabTitle) throws CUFException, HibernateException, Exception {
        int noOfRecords = 0;
        List rowCounts = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"storageName", (Object)storageName));
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"rowNumber")));
            rowCounts = criteria.list();
            transaction.commit();
            if (rowCounts == null || rowCounts.size() == 0) {
                throw new CUFException("Zestaw danych o nazwie " + storageName + " nie istnieje.");
            }
            int n = noOfRecords = rowCounts.size();
            return n;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<String> getDynamicTableStorageOwners(String storageName, String tabTitle) throws CUFException, HibernateException, Exception {
        List owners = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"storageName", (Object)storageName));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"username")));
            criteria.addOrder(Property.forName((String)"username").asc());
            owners = criteria.list();
            transaction.commit();
            if (owners == null || owners.size() == 0) {
                throw new CUFException("Zestaw danych o nazwie " + storageName + " nie istnieje.");
            }
            List list = owners;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<DynamicTableStorage> getDefaultDynamicTableStorageForUser(String username, String tabTitle) throws CUFException, HibernateException, Exception {
        List defaultStorage = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"defaultStorage", (Object)"true"), (Criterion)Restrictions.eq((String)"defaultStorage", (Object)"TRUE")));
            defaultStorage = criteria.list();
            transaction.commit();
            List list = defaultStorage;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static String getDefaultDynamicTableStorageNameForUser(String username, String tabTitle) throws CUFException, HibernateException, Exception {
        String defaultStorageName = "";
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"defaultStorage", (Object)"true"), (Criterion)Restrictions.eq((String)"defaultStorage", (Object)"TRUE")));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"storageName")));
            List result = criteria.list();
            if (result != null && result.size() > 0) {
                defaultStorageName = (String)result.get(0);
            }
            transaction.commit();
            String string = defaultStorageName;
            return string;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<String> getDynamicTableStorageColumnIds(String storageName, String username, String tabTitle) throws HibernateException, Exception {
        List columnIds = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(DynamicTableStorage.class);
            criteria.add((Criterion)Restrictions.eq((String)"storageName", (Object)storageName));
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
            criteria.add((Criterion)Restrictions.eq((String)"tabTitle", (Object)tabTitle));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"columnId")));
            columnIds = criteria.list();
            transaction.commit();
            List list = columnIds;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }
}

