/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table;

import com.google.common.base.Strings;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicProperties;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.docx4j.TextUtils;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTablesResolver {
    private static final Logger log = LoggerFactory.getLogger(DynamicTablesResolver.class);
    private static final int DYNAMI_TABLE_ROW_COUNT = 2;
    private static final String REQUIRE_CELL_CONTENT = "T";
    private static final String HEADERLESS_MARK = "H";
    private static final String GRAPHIC_COLUMN_MARK = "I";
    private static final String GRAPHIC_COLUMN_MARK_REGEX = "^I((\\(\\d+,\\d+\\))|(\\(\\d*,\\d*,\\d+\\)))$";

    public static List<TableInfo> getTables(MainDocumentPart documentPart) throws Exception {
        ArrayList<TableInfo> tablesInfo = new ArrayList<TableInfo>();
        List<Tbl> tables = DynamicTablesResolver.findTables(documentPart);
        for (Tbl table : tables) {
            tablesInfo.add(DynamicTablesResolver.getTableInfo(table));
        }
        return tablesInfo;
    }

    private static List<Tbl> findTables(MainDocumentPart documentPart) throws Exception {
        ArrayList<Tbl> tables = new ArrayList<Tbl>();
        List nodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
        for (Object node : nodes) {
            Object value;
            if (!(node instanceof JAXBElement) || !((value = ((JAXBElement)node).getValue()) instanceof Tbl)) continue;
            tables.add((Tbl)value);
        }
        return tables;
    }

    private static TableInfo getTableInfo(Tbl table) throws Exception {
        TableInfo info = new TableInfo();
        List<Tr> rows = DynamicTablesResolver.getRows(table);
        if (rows.size() != 2) {
            return info;
        }
        List<Tc> frCells = DynamicTablesResolver.getCells(rows.get(0));
        List<Tc> srCells = DynamicTablesResolver.getCells(rows.get(1));
        for (int i = 0; i < frCells.size(); ++i) {
            if (!DynamicTablesResolver.containsToken(frCells.get(i))) continue;
            if (DynamicTablesResolver.contentEquals(srCells.get(i), HEADERLESS_MARK)) {
                info.setDynamic(true);
                info.setHeaderless(true);
                continue;
            }
            if (DynamicTablesResolver.contentEquals(srCells.get(i), REQUIRE_CELL_CONTENT)) {
                info.setDynamic(true);
                continue;
            }
            if (DynamicTablesResolver.contentEquals(srCells.get(i), GRAPHIC_COLUMN_MARK)) {
                ColumnGraphicProperties cGP = new ColumnGraphicProperties(i);
                info.addGraphicPropertie(cGP);
                info.setDynamic(true);
                continue;
            }
            if (!DynamicTablesResolver.contentEqualsRegex(srCells.get(i), GRAPHIC_COLUMN_MARK_REGEX)) continue;
            String setWH = DynamicTablesResolver.getCellText(srCells.get(i));
            log.info("GRAPHIC_COLUMN_MARK:\t " + setWH);
            String firstMark = "I(";
            setWH = setWH.substring(firstMark.length(), setWH.indexOf(")"));
            String[] sizeWH = setWH.split(",");
            ColumnGraphicProperties cGP = new ColumnGraphicProperties(i);
            try {
                if (!Strings.isNullOrEmpty((String)sizeWH[0])) {
                    int width = Integer.parseInt(sizeWH[0]);
                    cGP.setWidth(width);
                }
                if (!Strings.isNullOrEmpty((String)sizeWH[1])) {
                    int height = Integer.parseInt(sizeWH[1]);
                    cGP.setHeight(height);
                }
                if (sizeWH.length > 2) {
                    int maxImageInRow = Integer.parseInt(sizeWH[2]);
                    cGP.setMaxImageInRow(maxImageInRow);
                }
            }
            catch (Exception e) {
                log.info("Invalid settings: \t" + setWH, (Throwable)e);
            }
            info.addGraphicPropertie(cGP);
            info.setDynamic(true);
        }
        return info;
    }

    private static boolean containsToken(Tc cell) {
        return DynamicTablesResolver.getCellText(cell).matches("@(.*)@");
    }

    private static boolean contentEquals(Tc cell, String string) {
        return DynamicTablesResolver.getCellText(cell).equals(string);
    }

    private static boolean contentEqualsRegex(Tc cell, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(DynamicTablesResolver.getCellText(cell));
        return m.matches();
    }

    private static String getCellText(Tc cell) {
        try {
            StringWriter content = new StringWriter();
            TextUtils.extractText((Object)cell, (Writer)content);
            return content.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static List<Tr> getRows(Tbl table) {
        return DynamicTablesResolver.getContent((ContentAccessor)table, Tr.class);
    }

    private static List<Tc> getCells(Tr row) {
        return DynamicTablesResolver.getContent((ContentAccessor)row, Tc.class);
    }

    private static <T> List<T> getContent(ContentAccessor element, Class<T> type) {
        ArrayList<T> content = new ArrayList<T>();
        for (Object item : element.getContent()) {
            Optional<T> unwrapped = DynamicTablesResolver.unwrap(item, type);
            if (!unwrapped.isPresent()) continue;
            content.add(unwrapped.get());
        }
        return content;
    }

    private static <T> Optional<T> unwrap(Object object, Class<T> type) {
        JAXBElement element;
        if (type.isAssignableFrom(object.getClass())) {
            return Optional.of(object);
        }
        if (object instanceof JAXBElement && type.isAssignableFrom((element = (JAXBElement)object).getDeclaredType())) {
            return Optional.of(element.getValue());
        }
        return Optional.empty();
    }
}

