/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NoImage {
    PDF("PDF", "noImagePDF.png"),
    DOC("DOC", "noImageDOC.png"),
    DOCX("DOCX", "noImageDOCX.png"),
    XLS("XLS", "noImageXLS.png"),
    PTT("PTT", "noImagePTT.png");

    private static final Logger log;
    private static final String DIR_RES = "DocTemplates2Pdf/images/";
    private static final String DEFAULT_FILE = "noImage.png";
    private String fileExtension;
    private String fileName;

    private NoImage(String fileExtension, String fileName) {
        this.fileExtension = fileExtension;
        this.fileName = fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static InputStream getInputStream(String extension) {
        for (NoImage noImageFile : NoImage.values()) {
            if (!noImageFile.getFileExtension().equalsIgnoreCase(extension)) continue;
            log.info("file noImage:\t" + noImageFile.fileName);
            return NoImage.class.getClassLoader().getResourceAsStream(DIR_RES + noImageFile.fileName);
        }
        log.info("file noImage:\tnoImage.png");
        return NoImage.class.getClassLoader().getResourceAsStream("DocTemplates2Pdf/images/noImage.png");
    }

    static {
        log = LoggerFactory.getLogger(NoImage.class);
    }
}

