/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooserManager;
import com.plusmpm.CUF.util.extension.CUFTools;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class QueryDataChooserManagement {
    public static Logger log = Logger.getLogger(QueryDataChooserManagement.class);

    public static void AddQueryDataChooserOnlyQuery(String sName, String sQuery) {
        log.info((Object)("************************ AddQueryDataChooserOnlyQuery(sName=" + sName + ", sQuery=" + sQuery + ") *************************"));
        long startTime = new Date().getTime();
        try {
            String[] namesTable = sName.split("$");
            String[] queryTable = sQuery.split("$");
            if (namesTable.length == queryTable.length) {
                for (int i = 0; i < namesTable.length; ++i) {
                    if (QueryDataChooserManager.checkExistenceOnlyQuery(namesTable[i], queryTable[i]) == -1L) {
                        QueryDataChooser queryDataChooser = new QueryDataChooser();
                        queryDataChooser.setName(namesTable[i]);
                        queryDataChooser.setQuery(queryTable[i]);
                        QueryDataChooserManager.save(queryDataChooser);
                        log.info((Object)("Zapytanie dla ExecuteQueryDataChooser o nazwie " + namesTable[i] + " dodane"));
                        continue;
                    }
                    log.warn((Object)("Zapytanie dla ExecuteQueryDataChooser o parametrach: " + namesTable[i] + ", " + queryTable[i] + " juz istnieje "));
                }
            } else {
                log.warn((Object)"Niepoprawnie zdefiniowane parametry zadania zaplanowanego. Sprawdz ilosc poszczegolnych parametrow rozdzielonych znakami $");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego AddQueryDataChooserOnlyQuery: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void AddQueryDataChooser(String sName, String sQuery, String sParameters, String sCountQuery, String sExternalDB, String sConfName, String sClassName) {
        log.info((Object)("************************ AddQueryDataChooser(sName=" + sName + ", sQuery=" + sQuery + ", sParameters=" + sParameters + ", sCountQuery=" + sCountQuery + ", sExternalDB=" + sExternalDB + ", sConfName=" + sConfName + ", sClassName=" + sClassName + ") *************************"));
        long startTime = new Date().getTime();
        try {
            String[] namesTable = sName.split("$");
            String[] queryTable = sQuery.split("$");
            String[] paramsTable = sParameters.split("$");
            String[] countQueryTable = sCountQuery.split("$");
            String[] externalDBTable = sExternalDB.split("$");
            String[] confNameTable = sConfName.split("$");
            String[] classNameTable = sClassName.split("$");
            if (namesTable.length == queryTable.length && namesTable.length == paramsTable.length && namesTable.length == countQueryTable.length && namesTable.length == externalDBTable.length && namesTable.length == confNameTable.length && namesTable.length == classNameTable.length) {
                for (int i = 0; i < namesTable.length; ++i) {
                    if (QueryDataChooserManager.checkExistence(namesTable[i], queryTable[i], paramsTable[i], countQueryTable[i], externalDBTable[i], confNameTable[i], classNameTable[i]) == -1L) {
                        QueryDataChooser queryDataChooser = new QueryDataChooser();
                        queryDataChooser.setName(namesTable[i]);
                        queryDataChooser.setQuery(queryTable[i]);
                        queryDataChooser.setParameters(paramsTable[i]);
                        queryDataChooser.setCountQuery(countQueryTable[i]);
                        queryDataChooser.setExternalDB(externalDBTable[i]);
                        queryDataChooser.setExternalDBConfName(confNameTable[i]);
                        queryDataChooser.setFullClassName(classNameTable[i]);
                        QueryDataChooserManager.save(queryDataChooser);
                        log.info((Object)("Zapytanie dla ExecuteQueryDataChooser o nazwie " + namesTable[i] + " dodane"));
                        continue;
                    }
                    log.warn((Object)("Zapytanie dla ExecuteQueryDataChooser o parametrach: " + namesTable[i] + ", " + queryTable[i] + ", " + countQueryTable[i] + ", " + externalDBTable[i] + ", " + confNameTable[i] + ", " + classNameTable[i] + " juz istnieje "));
                }
            } else {
                log.warn((Object)"Niepoprawnie zdefiniowane parametry zadania zaplanowanego. Sprawdz ilosc poszczegolnych parametrow rozdzielonych znakami $");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego AddQueryDataChooser: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void UpdateQueryDataChooser(String sName, String sQuery, String sParameters, String sCountQuery, String sExternalDB, String sConfName, String sClassName) {
        log.info((Object)("************************ UpdateQueryDataChooser(sName=" + sName + ", sQuery=" + sQuery + ", sParameters=" + sParameters + ", sCountQuery=" + sCountQuery + ", sExternalDB=" + sExternalDB + ", sConfName=" + sConfName + ", sClassName=" + sClassName + ") *************************"));
        long startTime = new Date().getTime();
        List<QueryDataChooser> queriesList = null;
        try {
            String[] namesTable = sName.split("$");
            String[] queryTable = sQuery.split("$");
            String[] paramsTable = sParameters.split("$");
            String[] countQueryTable = sCountQuery.split("$");
            String[] externalDBTable = sExternalDB.split("$");
            String[] confNameTable = sConfName.split("$");
            String[] classNameTable = sClassName.split("$");
            if (namesTable.length == queryTable.length && namesTable.length == paramsTable.length && namesTable.length == countQueryTable.length && namesTable.length == externalDBTable.length && namesTable.length == confNameTable.length && namesTable.length == classNameTable.length) {
                for (int i = 0; i < namesTable.length; ++i) {
                    queriesList = QueryDataChooserManager.getQueryDataChooserForName(namesTable[i]);
                    if (queriesList != null && queriesList.size() > 0) {
                        for (int j = 0; j < queriesList.size(); ++j) {
                            queriesList.get(j).setQuery(queryTable[j]);
                            queriesList.get(j).setParameters(paramsTable[j]);
                            queriesList.get(j).setCountQuery(countQueryTable[j]);
                            queriesList.get(j).setExternalDB(externalDBTable[j]);
                            queriesList.get(j).setExternalDBConfName(confNameTable[j]);
                            queriesList.get(j).setFullClassName(classNameTable[j]);
                            QueryDataChooserManager.update(queriesList.get(j));
                        }
                        log.info((Object)("Zapytanie dla ExecuteQueryDataChooser o nazwie " + namesTable[i] + " zostala zaktualizowane"));
                        continue;
                    }
                    log.warn((Object)("Zapytanie dla ExecuteQueryDataChooser o nazwie " + namesTable[i] + " nie istnieje "));
                }
            } else {
                log.warn((Object)"Niepoprawnie zdefiniowane parametry zadania zaplanowanego. Sprawdz ilosc poszczegolnych parametrow rozdzielonych znakami $");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego UpdateQueryDataChooser: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void DeleteQueryDataChooser(String sNames) {
        log.info((Object)("************************ DeleteQueryDataChooser(sNames=" + sNames + ") *************************"));
        long startTime = new Date().getTime();
        List<QueryDataChooser> queriesList = null;
        try {
            String[] namesTable = sNames.split(",");
            for (int i = 0; i < namesTable.length; ++i) {
                queriesList = QueryDataChooserManager.getQueryDataChooserForName(namesTable[i]);
                if (queriesList != null && queriesList.size() > 0) {
                    for (int j = 0; j < queriesList.size(); ++j) {
                        QueryDataChooserManager.delete(queriesList.get(j));
                    }
                    log.info((Object)("Zapytanie dla ExecuteQueryDataChooser o nazwie " + namesTable[i] + " usuniete"));
                    continue;
                }
                log.warn((Object)("Zapytanie dla ExecuteQueryDataChooser " + namesTable[i] + " nie istnieje "));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteQueryDataChooser: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void DeleteAllQueryDataChooser() {
        log.info((Object)"************************ DeleteAllQueryDataChooser() *************************");
        long startTime = new Date().getTime();
        QueryDataChooserManager manager = new QueryDataChooserManager();
        try {
            manager.deleteAll();
            log.info((Object)"Wszystkie zapytania dla ExecuteQueryDataChooser usuniete");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteAllQueryDataChooser: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

