/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.util.template;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.springframework.transaction.TransactionStatus;

public class WordTemplateUtil {
    private static DocumentService documentService = ServiceFactory.getDocumentService();
    private static DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
    private static DocumentClassActionService docClassActionService = ServiceFactory.getDocumentClassActionService();

    public static WfDocument archiveAndAttachToProcess(File document, String processId, String activityId, String documentClass, String template, WordTemplateService.OutputFormat format, boolean attachToProcess, boolean saveAsNewVersion) throws Exception {
        return WordTemplateUtil.archiveAndAttachToProcess(document, processId, activityId, documentClass, template, format, attachToProcess, saveAsNewVersion, null);
    }

    public static WfDocument attachToProcess(File f, String process, String activity, String template, String docClass, WordTemplateService.OutputFormat format, boolean saveAsNewVersion) throws Exception {
        return WordTemplateUtil.attachToProcess(f, process, activity, template, docClass, format, saveAsNewVersion, null);
    }

    public static WfDocument archiveAndAttachToProcess(File document, String processId, String activityId, String documentClass, String template, WordTemplateService.OutputFormat format, boolean attachToProcess, boolean saveAsNewVersion, String customFileName) throws Exception {
        return WordTemplateUtil.archiveAndAttachToProcess(document, processId, activityId, documentClass, template, format, attachToProcess, saveAsNewVersion, customFileName, null, null);
    }

    public static WfDocument archiveAndAttachToProcess(File document, String processId, String activityId, String documentClass, String template, WordTemplateService.OutputFormat format, boolean attachToProcess, boolean saveAsNewVersion, String customFileName, String fileDescription, Map<Long, Object> indexes) throws Exception {
        return WordTemplateUtil.archiveAndAttachToProcess(document, processId, activityId, documentClass, template, format, attachToProcess, saveAsNewVersion, customFileName, fileDescription, indexes, WordTemplateService.DocumentOwner.Administrator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WfDocument archiveAndAttachToProcess(File document, String processId, String activityId, String documentClass, String template, WordTemplateService.OutputFormat format, boolean attachToProcess, boolean saveAsNewVersion, String customFileName, String fileDescription, Map<Long, Object> indexes, WordTemplateService.DocumentOwner documentOwner) throws Exception {
        AddDocumentResultMeta documentResultMeta;
        if (attachToProcess) {
            documentResultMeta = WordTemplateUtil.attachFileToProcess(document, processId, activityId, template, documentClass, format, saveAsNewVersion, customFileName, fileDescription, indexes, documentOwner);
        } else {
            FileInputStream input = new FileInputStream(document);
            try {
                DocumentDefinition definition = WordTemplateUtil.getDocDefiniton(processId, template, documentClass, format, input, customFileName, fileDescription, saveAsNewVersion, indexes, documentOwner);
                documentResultMeta = documentService.addDocumentWithMetaResult(definition);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        docClassActionService.executeProcessActions(documentResultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, processId, activityId, documentResultMeta.getSavedAsNewVersion());
        return documentResultMeta.getDocument();
    }

    public static WfDocument attachToProcess(File file, String process, String activity, String template, String docClass, WordTemplateService.OutputFormat format, boolean saveAsNewVersion, String customFileName) throws Exception {
        return WordTemplateUtil.attachToProcess(file, process, activity, template, docClass, format, saveAsNewVersion, customFileName, null, null, WordTemplateService.DocumentOwner.Administrator);
    }

    private static AddDocumentResultMeta attachFileToProcess(File file, String process, String activity, String template, String docClass, WordTemplateService.OutputFormat format, boolean saveAsNewVersion, String customFileName, String fileDescription, Map<Long, Object> indexes, WordTemplateService.DocumentOwner documentOwner) throws Exception {
        FileInputStream is = new FileInputStream(file);
        DocumentDefinition definition = WordTemplateUtil.getDocDefiniton(process, template, docClass, format, is, customFileName, fileDescription, saveAsNewVersion, indexes, documentOwner);
        if (saveAsNewVersion) {
            DocumentFinder finder = FinderFactory.getDocumentFinder();
            List documents = finder.getDocumentsFromActivity(process, activity, new String[]{"documentClass"});
            FileService service = ServiceFactory.getFileService();
            WfDocument doc = WordTemplateUtil.getSingleDocument(documents, docClass);
            if (doc != null) {
                Long newDocId = service.checkIn(definition, Long.valueOf(doc.getFile().getId()), null);
                doc.getFile().setId(newDocId.longValue());
                return AddDocumentResultMeta.builder().document(doc).savedAsNewVersion(Boolean.valueOf(true)).build();
            }
        }
        AddDocumentResultMeta documentResultMeta = documentService.addDocumentWithMetaResult(definition);
        documentService.attachDocumentToProcess(documentResultMeta.getDocument(), "admin", process, activity);
        return documentResultMeta;
    }

    @Deprecated(since="4.2")
    public static WfDocument attachToProcess(File file, String process, String activity, String template, String docClass, WordTemplateService.OutputFormat format, boolean saveAsNewVersion, String customFileName, String fileDescription, Map<Long, Object> indexes, WordTemplateService.DocumentOwner documentOwner) throws Exception {
        return WordTemplateUtil.attachFileToProcess(file, process, activity, template, docClass, format, saveAsNewVersion, customFileName, fileDescription, indexes, documentOwner).getDocument();
    }

    private static DocumentDefinition getDocDefiniton(String process, String template, String docClass, WordTemplateService.OutputFormat format, InputStream is, String customFileName, String fileDescription, boolean isSaveAsNewVersion, Map<Long, Object> indexes, WordTemplateService.DocumentOwner documentOwner) {
        DocumentDefinition definition = new DocumentDefinition();
        Object fileName = StringUtils.isBlank((String)customFileName) ? WordTemplateUtil.getFileName(process, template, format) : customFileName + "." + format.toString().toLowerCase();
        definition.setDocumentClassId(docClassService.getDocumentClass(docClass, new String[0]).getId());
        definition.setFileName((String)fileName);
        String userName = "admin";
        if (documentOwner == WordTemplateService.DocumentOwner.LoggedUser) {
            userName = SessionUtils.getLoggedUserName();
        }
        definition.setUserName(userName);
        definition.setDescription(fileDescription);
        definition.setInputStream(is);
        definition.setSaveAsNewVersion(isSaveAsNewVersion);
        definition.setIndexes(indexes);
        return definition;
    }

    public static String getFileName(final String processId, final String template, final WordTemplateService.OutputFormat format) {
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        try {
            return (String)tx.execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

                public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                    String name = WordTemplateUtil.getFileName(transaction, processId, template) + "." + format.toString().toLowerCase();
                    return name.replaceAll("[^\\sa-zA-Z0-9.-]", "_");
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getFileName(SharkTransaction t, String processId, String template) throws Exception {
        WfProcess process = SharkFunctions.getWfProcess((SharkTransaction)t, (String)processId);
        String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)t, (String)processId);
        String processName = LanguageUtils.getProcessName((String)process.name(t), (String)processDefId);
        return template + " - " + processName;
    }

    private static WfDocument getSingleDocument(List<WfDocument> documents, String className) {
        WfDocument document = null;
        for (WfDocument doc : documents) {
            if (!doc.getFile().getDocumentClass().getName().equals(className)) continue;
            if (document == null) {
                document = doc;
                continue;
            }
            return null;
        }
        return document;
    }
}

