/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.google.gson.Gson;
import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.DocumentAuthorization;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CheckFileRights
extends HttpServlet {
    public static Logger log = Logger.getLogger(CheckFileRights.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sFileId = req.getParameter("fileId");
        String type = req.getParameter("type");
        String userName = (String)req.getSession().getAttribute("username");
        JsonMessage jm = new JsonMessage();
        long fileId = this.readFileId(sFileId);
        try {
            Long docClassId = this.getDocClassIdForFile(fileId);
            this.validateType(type);
            String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).custom((Object)type).build();
            int right = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
            if (0 == right || DocumentAuthorization.isFileOwner(fileId, userName)) {
                jm.setData("full");
                jm.setStatus(0);
            } else {
                jm.setData("noRights");
                jm.setStatus(0);
            }
        }
        catch (CUFException e) {
            jm.setErrorMsg(e.getMessage());
            jm.setStatus(-1);
        }
        catch (Exception e) {
            jm.setErrorMsg(e.getMessage());
            jm.setStatus(-1);
        }
        finally {
            resp.getWriter().print(new Gson().toJson((Object)jm));
        }
    }

    private Long getDocClassIdForFile(Long fileId) {
        DBManagement dbm = new DBManagement();
        String docClassName = ArchiveServices.GetDocClassNameForDocument(String.valueOf(fileId));
        DocClassTable dct = dbm.getDocClassByName(docClassName);
        return dct.getId();
    }

    private void validateType(String type) throws CUFException {
        String[] validTypes = new String[]{"release", "modify", "delete", "read"};
        boolean isValidType = Arrays.asList(validTypes).contains(type);
        if (!isValidType) {
            throw new CUFException("notValidType");
        }
    }

    private long readFileId(String sFileId) {
        long fileId = Long.valueOf(sFileId);
        return fileId;
    }
}

