/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.currencyExchangeRates.CurrencyExchangeRate;
import com.plusmpm.CUF.database.currencyExchangeRates.CurrencyExchangeRateManager;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CurrencyExchangeRates {
    public static Logger log = Logger.getLogger(CurrencyExchangeRates.class);
    private static final String uFilesDir = "https://static.nbp.pl/dane/kursy/xml/";
    private static final String uFilePrefix = "dir";
    private static final String uFileExtension = ".txt";
    private static List<String> currencyList = new ArrayList<String>();
    private static Calendar tmpCal;
    private static RetryPolicy<Object> retryPolicy;

    private static int diffrenceBetweenDates(Calendar c1, Calendar c2) {
        long milis1 = c1.getTimeInMillis();
        long milis2 = c2.getTimeInMillis();
        long diff = milis2 - milis1;
        int diffDays = (int)(diff / 86400000L);
        return diffDays;
    }

    public static void GetCurrencyExchangeRates(int days, String tableWithCurrency) {
        ArrayList<CurrencyExchangeRate> rates = new ArrayList<CurrencyExchangeRate>();
        Date lastDate = null;
        Date firstDate = null;
        Calendar minDate = Calendar.getInstance();
        minDate.add(5, -days - 1);
        try {
            currencyList = CurrencyExchangeRateManager.getCurrencySet(tableWithCurrency);
            for (int i = 0; i < currencyList.size(); ++i) {
                currencyList.set(i, currencyList.get(i).toUpperCase());
            }
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas pobierania listy walut walut");
            log.error((Object)e);
        }
        try {
            CurrencyExchangeRateManager.clearRatesBeforeDate(minDate.getTime());
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas usuwania starych walut");
            log.error((Object)e);
        }
        Calendar startDate = Calendar.getInstance();
        try {
            lastDate = CurrencyExchangeRateManager.getExtremeCurrencyDate(true);
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania ostaniej daty pobierania walut.");
            log.error((Object)e);
        }
        try {
            firstDate = CurrencyExchangeRateManager.getExtremeCurrencyDate(false);
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania pierwszej daty pobierania walut.");
            log.error((Object)e);
        }
        if (lastDate == null || minDate.getTime().getTime() < firstDate.getTime()) {
            log.info((Object)"W bazie nie s\u0105 zapisane \u017cadne waluty lub zwiekszono czas po ktorym kursy beda usuwane. Pobieram waluty z wyznaczonego okresu");
            startDate = minDate;
        } else {
            startDate.setTime(lastDate);
        }
        Calendar now = Calendar.getInstance();
        days = CurrencyExchangeRates.diffrenceBetweenDates(startDate, now);
        log.info((Object)("Ilo\u015b\u0107 dni o kt\u00f3re sie cofam: " + days));
        log.info((Object)("Pocz\u0105tek okresu: " + String.valueOf(startDate)));
        int day = startDate.get(5);
        int month = startDate.get(2) + 1;
        int year = startDate.get(1);
        int currentYear = now.get(1);
        log.info((Object)("day: " + day));
        log.info((Object)("month: " + month));
        log.info((Object)("year: " + year));
        List<Integer> years = CurrencyExchangeRates.getAllYearsUntilToday(year, currentYear);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < years.size(); ++i) {
            BufferedReader in = null;
            try {
                String fileName;
                URL url = new URL(CurrencyExchangeRates.getFileListPath(i, years));
                InputStream inputStream = (InputStream)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> url.openStream());
                in = new BufferedReader(new InputStreamReader(inputStream));
                Calendar fileDate = Calendar.getInstance();
                boolean firstLine = true;
                while ((fileName = in.readLine()) != null) {
                    if (firstLine) {
                        fileName = CurrencyExchangeRates.removeUTF8BOM(fileName);
                        firstLine = false;
                    }
                    String date = CurrencyExchangeRates.getDateFromFilename(fileName);
                    fileDate.setTime(new SimpleDateFormat("yyMMdd").parse(date));
                    if (!fileName.matches("^[ab].*") || startDate.compareTo(fileDate) > 0) continue;
                    fileNames.add(fileName);
                    log.info((Object)fileName);
                }
                continue;
            }
            catch (MalformedURLException e) {
                log.error((Object)"B\u0142\u0105d podczas pobierania list plik\u00f3w z kursami");
                log.error((Object)e);
                continue;
            }
            catch (IOException e) {
                log.error((Object)"B\u0142\u0105d podczas pobierania list plik\u00f3w z kursami");
                log.error((Object)e);
                try {
                    in.close();
                }
                catch (IOException e1) {
                    log.error((Object)"B\u0142\u0105d podczas zamykania strumienia danych");
                    log.error((Object)e);
                }
                continue;
            }
            catch (ParseException e) {
                log.error((Object)"B\u0142\u0105d podczas parsowania daty");
                log.error((Object)e);
            }
        }
        try {
            Collections.reverse(fileNames);
            CurrencyExchangeRates.readRates(fileNames, rates);
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas wczytywania kurs\u00f3w");
            log.error((Object)e);
        }
        try {
            CurrencyExchangeRateManager.save(rates);
        }
        catch (Exception e) {
            log.error((Object)"b\u0142\u0105d podczas zapisu listy kurs\u00f3w");
            log.error((Object)e);
        }
    }

    private static String getDateFromFilename(String fileName) {
        return fileName.substring(fileName.length() - 6);
    }

    private static String removeUTF8BOM(String fileName) {
        if (fileName.startsWith("\ufeff")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private static String getFileListPath(int i, List<Integer> years) {
        StringBuilder fileListPath = new StringBuilder();
        fileListPath.append(uFilesDir);
        fileListPath.append(uFilePrefix);
        if (CurrencyExchangeRates.isNotLast(i, years)) {
            fileListPath.append(years.get(i));
        }
        fileListPath.append(uFileExtension);
        return fileListPath.toString();
    }

    private static boolean isNotLast(int i, List<Integer> years) {
        return i < years.size() - 1;
    }

    private static List<Integer> getAllYearsUntilToday(int year, int currentYear) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (year <= currentYear) {
            result.add(year);
            ++year;
        }
        return result;
    }

    private static List<CurrencyExchangeRate> readRates(List<String> fileNames, final List<CurrencyExchangeRate> rates) throws IOException, ParserConfigurationException, SAXException {
        for (String fileName : fileNames) {
            log.info((Object)("Rozpoczynam wczytywanie pliku: " + fileName));
            tmpCal = Calendar.getInstance();
            tmpCal.set(1, Integer.valueOf("20" + fileName.substring(5, 7)));
            tmpCal.set(2, Integer.valueOf(fileName.substring(7, 9)) - 1);
            tmpCal.set(5, Integer.valueOf(fileName.substring(9)));
            tmpCal.set(10, 0);
            tmpCal.set(12, 0);
            tmpCal.set(13, 0);
            tmpCal.set(14, 0);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler dh = new DefaultHandler(){
                CurrencyExchangeRate cer;
                boolean valid = false;
                boolean nazwa_waluty = false;
                boolean przelicznik = false;
                boolean kod_waluty = false;
                boolean kurs_sredni = false;

                @Override
                public void startElement(String uri, String localName, String node, Attributes attributes) throws SAXException {
                    if (node.equalsIgnoreCase("pozycja")) {
                        this.cer = new CurrencyExchangeRate();
                        this.cer.setDate(tmpCal.getTime());
                        log.info((Object)("Data waluty: " + this.cer.getDate().toString()));
                    }
                    if (node.equalsIgnoreCase("nazwa_waluty")) {
                        this.nazwa_waluty = true;
                    }
                    if (node.equalsIgnoreCase("przelicznik")) {
                        this.przelicznik = true;
                    }
                    if (node.equalsIgnoreCase("kod_waluty")) {
                        this.kod_waluty = true;
                    }
                    if (node.equalsIgnoreCase("kurs_sredni")) {
                        this.kurs_sredni = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String node) throws SAXException {
                    if (node.equalsIgnoreCase("pozycja") && this.valid) {
                        rates.add(this.cer);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.nazwa_waluty) {
                        this.cer.setName(new String(ch, start, length));
                        log.info((Object)("Nazwa waluty: " + this.cer.getName()));
                        this.nazwa_waluty = false;
                    }
                    if (this.przelicznik) {
                        this.cer.setConversion(Integer.valueOf(new String(ch, start, length)));
                        log.info((Object)("Przelicznik waluty: " + this.cer.getConversion()));
                        this.przelicznik = false;
                    }
                    if (this.kod_waluty) {
                        String code = new String(ch, start, length);
                        log.info((Object)("Kod waluty: " + code));
                        if (currencyList.contains(code.toUpperCase())) {
                            log.info((Object)"Pobieram");
                            this.valid = true;
                            this.cer.setCode(code);
                        } else {
                            this.valid = false;
                            log.info((Object)"Nie pobieram");
                        }
                        this.kod_waluty = false;
                    }
                    if (this.kurs_sredni) {
                        this.cer.setRate(Double.valueOf(new String(ch, start, length).replace(",", ".")));
                        log.info((Object)("Kurs \u015bredni: " + this.cer.getRate()));
                        this.kurs_sredni = false;
                    }
                }
            };
            URL url = new URL(uFilesDir + fileName + ".xml");
            Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> saxParser.parse(url.openStream(), dh));
        }
        return rates;
    }

    static {
        retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{IOException.class, ConnectException.class})).withDelay(Duration.ofSeconds(10L)).withMaxRetries(6).build();
    }
}

