/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.suncode.cuf.mail.FileAttachment;
import com.suncode.cuf.mail.MailContent;
import com.suncode.pwfl.archive.WfDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.StringUtils;

public class SimpleMailContent
implements MailContent {
    protected String subject;
    protected String content;
    private List<String> attachments = new ArrayList<String>();
    private Map<String, String> attachmentsNames = new HashMap<String, String>();
    private Map<Long, String> documents = new HashMap<Long, String>();

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public List<String> getAttachments() {
        return this.attachments;
    }

    @Override
    public List<FileAttachment> getAttachedFiles() {
        ArrayList<FileAttachment> attachments = new ArrayList<FileAttachment>();
        for (String path : this.attachments) {
            String name = this.attachmentsNames.get(path);
            attachments.add(new FileAttachment(name, path));
        }
        return attachments;
    }

    @Override
    public Map<Long, String> getDocuments() {
        return this.documents;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
        this.attachmentsNames.clear();
        for (String attachment : this.attachments) {
            this.attachmentsNames.put(attachment, this.getDefaultAttachmentName(attachment));
        }
    }

    public void setWfDocuments(List<WfDocument> wfDocuments) {
        this.documents.clear();
        for (WfDocument wfDocument : wfDocuments) {
            Long fileId = wfDocument.getFile().getId();
            this.documents.put(fileId, this.getDefaultWfDocumentName(wfDocument));
        }
    }

    public void addWfDocument(String name, WfDocument wfDocument) {
        if (!StringUtils.hasText((String)name)) {
            name = this.getDefaultWfDocumentName(wfDocument);
        }
        Long fileId = wfDocument.getFile().getId();
        this.documents.put(fileId, name);
    }

    public void addAttachment(String name, String path) {
        if (!StringUtils.hasText((String)name)) {
            name = this.getDefaultAttachmentName(path);
        }
        this.attachments.add(path);
        this.attachmentsNames.put(path, name);
    }

    @Override
    public boolean hasAttachment() {
        return !this.attachments.isEmpty() || !this.documents.isEmpty();
    }

    private String getDefaultAttachmentName(String path) {
        return FilenameUtils.getName((String)path);
    }

    private String getDefaultWfDocumentName(WfDocument wfDocument) {
        return wfDocument.getFile().getFileName();
    }
}

