/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.DocumentAuthorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DetachDocumentFromProcess
extends HttpServlet {
    public static Logger log = Logger.getLogger(DetachDocumentFromProcess.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private boolean readBoolean(String str) {
        try {
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DettachDocumentFromProcess Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        boolean bSuccess = false;
        String answerMessage = "";
        try {
            boolean hasRights;
            long fileId;
            String sProcessId = request.getParameter("sProcessId");
            String sActivityId = request.getParameter("sActivityId");
            String sFileId = request.getParameter("sFileId");
            String sCheckRights = request.getParameter("checkRights");
            boolean checkRights = this.readBoolean(sCheckRights);
            if (Tools.isNullOrEmpty((String)sProcessId) || Tools.isNullOrEmpty((String)sActivityId)) {
                throw new CUFException("Brak informacji o identyfikatrze procesu lub zadania.");
            }
            try {
                fileId = Long.parseLong(sFileId);
            }
            catch (NumberFormatException e) {
                throw new CUFException("Podany identyfikator pliku nie jest warto\u015bci\u0105 liczbow\u0105.");
            }
            String userName = (String)request.getSession().getAttribute("username");
            if (checkRights && !(hasRights = DocumentAuthorization.checkDetachRights(fileId, userName))) {
                throw new CUFException("noRights");
            }
            FileService fs = ServiceFactory.getFileService();
            fs.detachFileFromProcess(Long.valueOf(fileId), sProcessId);
            log.info((Object)("Od\u0142\u0105czono dokument o identyfikatorze " + sFileId + " od procesu o identyfikatorze " + sProcessId));
            bSuccess = true;
            WfFile f = fs.getFile(Long.valueOf(fileId), new String[]{"documentClass"});
            answerMessage = f.getDocumentClass().getName();
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d podczas od\u0142\u0105czania dokumentu od procesu.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

