/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

@Deprecated(since="4.2", forRemoval=true)
public class ExportDefaultViews
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDefaultViews.class);

    @AdvancedTask(name="ExportDefaultViewsToXLS", description="ExportDefaultViewsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDefaultViewsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDefaultViewsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        int colPos = 0;
        int rowPos = 0;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet panelsSheet = workbook.createSheet("Widoki domy\u015blne", 0);
            log.info((Object)"Utworzono arkusz do eksportu widokow domyslnych uzytkownikow");
            String[] colIDsDefaultView = new String[]{"U\u017cytkownik", "Wersja j\u0119zykowa", "Szablon", "Ilo\u015b\u0107 pozycji na stronie", "Typ widoku domy\u015blnego", "Podtyp widoku domy\u015blnego"};
            String[] colIDsPanel = new String[]{"Nazwa panelu", "Opis"};
            String[] colIDsParam = new String[]{"Typ parametru", "Nazwa parametru", "Pozycja", "Czy liczy\u0107?"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (i = 0; i < colIDsDefaultView.length; ++i) {
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, 0, colIDsDefaultView[i], times12format, cellView);
                ++colPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.YELLOW);
            for (i = 0; i < colIDsPanel.length; ++i) {
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, 0, colIDsPanel[i], times12format, cellView);
                ++colPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.ORANGE);
            for (i = 0; i < colIDsParam.length; ++i) {
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, 0, colIDsParam[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie widokow domyslnych z systemu dla poszczegolnych uzytkownikow");
            String[] userTable = uga.getAllUsers();
            if (userTable == null || userTable.length == 0) {
                throw new CUFException("Brak uzytkownikow w systemie");
            }
            for (String userId : userTable) {
                log.info((Object)("Pobieranie widoku domyslnego dla uzytkownika " + userId));
                colPos = 0;
                String language = dbm.GetUserData(userId, "language");
                String template = dbm.GetUserData(userId, "template");
                String pageSize = dbm.GetUserData(userId, "pageSize");
                String defaultView = dbm.GetUserData(userId, "defaultView");
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, ++rowPos, userId, null, cellView);
                ++colPos;
                if (Tools.isNullOrEmpty((String)language) || language.equalsIgnoreCase("default")) {
                    language = "Domy\u015blny";
                }
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, rowPos, language, null, cellView);
                ++colPos;
                if (Tools.isNullOrEmpty((String)template)) {
                    template = "plusmpm";
                }
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, rowPos, template, null, cellView);
                ++colPos;
                if (Tools.isNullOrEmpty((String)pageSize) || pageSize.equalsIgnoreCase("default")) {
                    pageSize = "Domy\u015blna";
                }
                CUFTools.addCellToXLSSheet(panelsSheet, colPos, rowPos, pageSize, null, cellView);
                String[] defaultViewConfTab = ExportDefaultViews.getDefaultViewTypeAndName(defaultView);
                CUFTools.addCellToXLSSheet(panelsSheet, ++colPos, rowPos, defaultViewConfTab[0], null, cellView);
                CUFTools.addCellToXLSSheet(panelsSheet, ++colPos, rowPos, defaultViewConfTab[1], null, cellView);
                ++colPos;
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport widokow domyslnych dla uzytkownikow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania widokow domyslnych dla uzytkownikow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDefaultViewsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static String[] getDefaultViewTypeAndName(String defaultViewId) throws CUFException, Exception {
        log.trace((Object)("************ getDefaultViewTypeAndName(defaultViewId=" + defaultViewId + ") ************"));
        String[] defaultViewConfTab = new String[2];
        String defaultViewType = "";
        String defaultViewName = "";
        DBManagement dbm = new DBManagement();
        if (Tools.isNullOrEmpty((String)defaultViewId)) {
            defaultViewType = "Domy\u015blny";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("admin")) {
            defaultViewType = "Administracja";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("task")) {
            defaultViewType = "Skrzynka zada\u0144";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("createprocess")) {
            defaultViewType = "Utw\u00f3rz proces";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("archive")) {
            defaultViewType = "Archiwum dokument\u00f3w";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("calendar")) {
            defaultViewType = "M\u00f3j kalendarz";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("searchprocess")) {
            defaultViewType = "Znajd\u017a proces";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("stats")) {
            defaultViewType = "Statystyki";
            defaultViewName = "";
        } else if (defaultViewId.equalsIgnoreCase("docclasses")) {
            defaultViewType = "Klasy dokument\u00f3w";
            defaultViewName = "";
        } else if (defaultViewId.startsWith("docclass_")) {
            defaultViewType = "Klasa dokument\u00f3w";
            int startPos = defaultViewId.indexOf("_");
            String docClassId = defaultViewId.substring(startPos + 1, defaultViewId.length());
            DocClassTable docClassTable = DBManagement.getDocClass((String)docClassId);
            if (docClassTable != null) {
                defaultViewName = docClassTable.getDocClassName();
            }
        } else if (defaultViewId.equalsIgnoreCase("links")) {
            defaultViewType = "Zestawy dokument\u00f3w";
            defaultViewName = "";
        } else if (defaultViewId.startsWith("link_")) {
            defaultViewType = "Zestaw dokument\u00f3w";
            int startPos = defaultViewId.indexOf("_");
            String linkId = defaultViewId.substring(startPos + 1, defaultViewId.length());
            LinkService linkService = (LinkService)SpringContext.getBean(LinkService.class);
            Link linkTable = (Link)linkService.get((Serializable)Long.valueOf(linkId));
            if (linkTable != null) {
                defaultViewName = linkTable.getName();
            }
        } else if (defaultViewId.equalsIgnoreCase("myviews")) {
            defaultViewType = "Moje widoki";
            defaultViewName = "";
        } else if (defaultViewId.startsWith("myview_")) {
            defaultViewType = "Widok";
            int startPos = defaultViewId.indexOf("_");
            String viewId = defaultViewId.substring(startPos + 1, defaultViewId.length());
            UserSearchViewTable viewTable = dbm.getUserSearchView(viewId);
            if (viewTable != null) {
                defaultViewName = viewTable.getViewName();
            }
        } else {
            throw new CUFException("Nieznany typ widoku domyslnego (" + defaultViewId + ")");
        }
        defaultViewConfTab[0] = defaultViewType;
        defaultViewConfTab[1] = defaultViewName;
        return defaultViewConfTab;
    }

    private static String getPanelParamTypeName(String panelParamTypeId) throws CUFException, Exception {
        log.trace((Object)("************ getPanelParamTypeName(panelParamTypeId=" + panelParamTypeId + ") ************"));
        String panelParamTypeName = "";
        if (panelParamTypeId.equalsIgnoreCase("myviews")) {
            panelParamTypeName = "Moje widoki";
        } else if (panelParamTypeId.equalsIgnoreCase("links")) {
            panelParamTypeName = "Zestawy dokumnet\u00f3w";
        } else if (panelParamTypeId.equalsIgnoreCase("createprocess")) {
            panelParamTypeName = "Utw\u00f3rz proces";
        } else if (panelParamTypeId.equalsIgnoreCase("archive")) {
            panelParamTypeName = "Archiwum dokument\u00f3w";
        } else if (panelParamTypeId.equalsIgnoreCase("myview")) {
            panelParamTypeName = "Widok";
        } else if (panelParamTypeId.equalsIgnoreCase("task")) {
            panelParamTypeName = "Skrzynka zada\u0144";
        } else if (panelParamTypeId.equalsIgnoreCase("docclasses")) {
            panelParamTypeName = "Klasy dokument\u00f3w";
        } else if (panelParamTypeId.equalsIgnoreCase("docclass")) {
            panelParamTypeName = "Klasa dokument\u00f3w";
        } else if (panelParamTypeId.equalsIgnoreCase("link")) {
            panelParamTypeName = "Zestaw dokumnet\u00f3w";
        } else if (panelParamTypeId.equalsIgnoreCase("process")) {
            panelParamTypeName = "Proces";
        } else {
            throw new CUFException("Nieznany typ parametru w panelu uzytkownika (" + panelParamTypeId + ")");
        }
        return panelParamTypeName;
    }
}

