/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.PeriodUnit;
import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

@Deprecated(since="4.2", forRemoval=true)
public class ExportPlannedExternalTasks
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportPlannedExternalTasks.class);

    @AdvancedTask(name="ExportScheduledTasksToXLS", description="ExportScheduledTasksToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportScheduledTasksToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportScheduledTasksToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        List scheduledTasks = null;
        int columnPos = 0;
        int rowPos = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet scheduledTasksSheet = workbook.createSheet("Zadania zaplanowane", 0);
            log.info((Object)"Utworzono arkusz do eksportu zadan zaplanowanych");
            String[] colIDsTask = new String[]{"Nazwa zadania", "Opis", "Klasa", "Metoda", "Aktywne", "Okres - ilo\u015b\u0107", "Okres - jednostka", "Data pierwszego uruchomienia", "Data nast\u0119pnego uruchomienia", "Liczba parametr\u00f3w"};
            String[] colIDsParameter = new String[]{"Typ parametru", "Warto\u015b\u0107 parametru"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (i = 0; i < colIDsTask.length; ++i) {
                CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, 0, colIDsTask[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.YELLOW);
            for (i = 0; i < colIDsParameter.length; ++i) {
                CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, 0, colIDsParameter[i], times12format, cellView);
                ++columnPos;
            }
            log.info((Object)"Pobieranie zadan zaplanowanych z systemu");
            scheduledTasks = ScheduledTasksMethods.getAllScheduledTasks();
            if (scheduledTasks != null && scheduledTasks.size() > 0) {
                for (ScheduledTasksTable scheduledTask : scheduledTasks) {
                    if (scheduledTask == null) continue;
                    String taskName = scheduledTask.getName();
                    String taskDescr = scheduledTask.getDescription();
                    String className = scheduledTask.getClass_name();
                    String methodName = scheduledTask.getMethod_name();
                    boolean bIsActive = scheduledTask.getIs_active();
                    String isActive = "";
                    PeriodUnit enumPeriodUnit = scheduledTask.getPeriodUnit();
                    String periodAmount = String.valueOf(scheduledTask.getPeriodValue());
                    String periodUnit = "";
                    Date dFirstRun = scheduledTask.getFirst_run();
                    String firstRun = "";
                    Date dNextRun = scheduledTask.getNext_run();
                    String nextRun = "";
                    if (className.equals("com.plusmpm.CUF.util.PlannedExternalTask.ExportPlannedExternalTasks") && methodName.equals("ExportScheduledTasksToXLS") || className.equals("com.plusmpm.CUF.util.PlannedExternalTask.ExportSystemSettings") && methodName.equals("ExportSystemSettingsToXLSFiles")) continue;
                    columnPos = 0;
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, ++rowPos, taskName, null, cellView);
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, taskDescr, null, cellView);
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, className, null, cellView);
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, methodName, null, cellView);
                    isActive = bIsActive ? "tak" : "nie";
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, isActive, null, cellView);
                    periodUnit = PeriodUnit.MINUTES.equals((Object)enumPeriodUnit) ? "minuty" : (PeriodUnit.HOURS.equals((Object)enumPeriodUnit) ? "godziny" : (PeriodUnit.DAYS.equals((Object)enumPeriodUnit) ? "dni" : (PeriodUnit.MONTHS.equals((Object)enumPeriodUnit) ? "miesi\u0105ce" : "lata")));
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, periodAmount, null, cellView);
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, periodUnit, null, cellView);
                    ++columnPos;
                    if (dFirstRun != null) {
                        firstRun = sdf.format(dFirstRun);
                    }
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, rowPos, firstRun, null, cellView);
                    ++columnPos;
                    if (dNextRun != null) {
                        nextRun = sdf.format(dNextRun);
                    }
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, rowPos, nextRun, null, cellView);
                    ++columnPos;
                    Long id = scheduledTask.getId();
                    if (id == null) continue;
                    List<ScheduledTasksParametersTable> scheduledTaskParameters = ExportPlannedExternalTasks.getListOfParams(id);
                    if (scheduledTaskParameters != null && scheduledTaskParameters.size() > 0) {
                        scheduledTaskParameters = ExportPlannedExternalTasks.sortParams(scheduledTaskParameters);
                        CUFTools.addCellToXLSSheet(scheduledTasksSheet, colIDsTask.length - 1, rowPos, String.valueOf(scheduledTaskParameters.size()), null, cellView);
                        for (ScheduledTasksParametersTable scheduledTaskParameter : scheduledTaskParameters) {
                            if (scheduledTaskParameter == null) continue;
                            columnPos = colIDsTask.length;
                            String parameterType = scheduledTaskParameter.getParameter_type();
                            String parameterValue = scheduledTaskParameter.getParameter_value();
                            CUFTools.addCellToXLSSheet(scheduledTasksSheet, columnPos, ++rowPos, parameterType, null, cellView);
                            CUFTools.addCellToXLSSheet(scheduledTasksSheet, ++columnPos, rowPos, parameterValue, null, cellView);
                            ++columnPos;
                        }
                        continue;
                    }
                    log.info((Object)("Brak parametrow dla zadania zaplanowanego o nazwie " + taskName));
                    CUFTools.addCellToXLSSheet(scheduledTasksSheet, colIDsTask.length - 1, rowPos, "0", null, cellView);
                }
            } else {
                log.info((Object)"Brak zadan zaplanowanych zdefiniowanych w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport zadan zaplanowanych do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania zadan zaplanowanych. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportScheduledTasksToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static List<ScheduledTasksParametersTable> getListOfParams(long id) {
        log.trace((Object)("************ getListOfParams(id=" + String.valueOf(id) + ") ************"));
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from ScheduledTasksParametersTable where scheduled_task_id=:ident").setParameter("ident", (Object)id).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private static List<ScheduledTasksParametersTable> sortParams(List<ScheduledTasksParametersTable> params) throws Exception {
        ArrayList<ScheduledTasksParametersTable> sortedParams = new ArrayList<ScheduledTasksParametersTable>();
        for (ScheduledTasksParametersTable oneParam : params) {
            if (oneParam == null) continue;
            int paramPos = oneParam.getParameter_position();
            if (sortedParams.size() == 0) {
                sortedParams.add(oneParam);
                continue;
            }
            boolean bAdded = false;
            for (int i = 0; i < sortedParams.size(); ++i) {
                ScheduledTasksParametersTable sortedParam = (ScheduledTasksParametersTable)sortedParams.get(i);
                int sortedParamPos = sortedParam.getParameter_position();
                if (paramPos >= sortedParamPos) continue;
                sortedParams.add(i, oneParam);
                bAdded = true;
                break;
            }
            if (bAdded) continue;
            sortedParams.add(oneParam);
        }
        return sortedParams;
    }
}

