/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.administartion.structure.internal;

import com.suncode.cuf.administartion.structure.OrganizationalUnitHelper;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.util.QueryExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrganizationalUnitHelperImpl
implements OrganizationalUnitHelper {
    @Autowired
    private QueryExecutor qu;
    @Autowired
    private OrganizationalUnitFinder ouf;

    @Override
    public List<OrganizationalUnit> findByRoleId(Long roleId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct {ou.*} from pm_positions p ");
        sb.append("left join pm_position_role pr on pr.positionid=p.id ");
        sb.append("left join pm_organizationalunits ou on ou.id=p.organizationalunitid ");
        sb.append("where pr.roleid=:roleId ");
        SQLQuery sql = this.qu.createSQLQuery(sb.toString());
        sql.setParameter("roleId", (Object)roleId);
        sql.addEntity("ou", OrganizationalUnit.class);
        List ous = sql.list();
        return ous;
    }

    @Override
    public List<String> getAllOuSymbols() {
        DetachedCriteria dc = DetachedCriteria.forClass(OrganizationalUnit.class);
        dc.setProjection((Projection)Projections.property((String)"symbol"));
        return this.qu.findByCriteria(dc);
    }

    @Override
    public List<OrganizationalUnit> getHighestOrganizationalUnitsForUser(String userName) {
        List directUserOus = this.ouf.findByUserName(userName, new String[0]);
        ArrayList<OrganizationalUnit> highestUserOus = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit directUserOu : directUserOus) {
            highestUserOus.add(this.getHighestOrganizationalUnit(directUserOu.getId()));
        }
        return highestUserOus;
    }

    @Override
    public OrganizationalUnit getHighestOrganizationalUnit(Long ouId) {
        OrganizationalUnit baseOu = (OrganizationalUnit)this.ouf.get((Serializable)ouId, new String[]{"higherOrganizationalUnit"});
        return this.getHighestOrganizationalUnit(baseOu.getId(), baseOu);
    }

    private OrganizationalUnit getHighestOrganizationalUnit(Long ouId, OrganizationalUnit baseOu) {
        OrganizationalUnit ou = (OrganizationalUnit)this.ouf.get((Serializable)ouId, new String[]{"higherOrganizationalUnit"});
        OrganizationalUnit higherOu = ou.getHigherOrganizationalUnit();
        if (higherOu == null) {
            return ou;
        }
        if (higherOu.getId().equals(baseOu.getId())) {
            return baseOu;
        }
        return this.getHighestOrganizationalUnit(higherOu.getId(), baseOu);
    }
}

