/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.util.Tools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportDynamicTableScheme
extends HttpServlet {
    public static Logger log = Logger.getLogger(ExportDynamicTableScheme.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* ExportDynamicTableScheme Servlet ****************************");
        ServletOutputStream outputStream = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WorkbookSettings wbs = null;
        WritableWorkbook w = null;
        try {
            String colNames = request.getParameter("cols");
            Object docName = request.getParameter("docName");
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            String[] keys = colNames.split(";");
            outputStream = response.getOutputStream();
            log.info((Object)"Tworzenie szablonu tabeli dynamicznej");
            w = Workbook.createWorkbook((OutputStream)bos, (WorkbookSettings)wbs);
            WritableSheet sheet = w.createSheet("Schemat tabeli dynamicznej", 0);
            WritableFont times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.WHITE);
            WritableCellFormat times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBackground(Colour.BLUE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            CellView cellView = new CellView();
            cellView.setAutosize(true);
            for (int i = 0; i < keys.length; ++i) {
                Label label = new Label(i, 0, keys[i], (CellFormat)times12format);
                sheet.addCell((WritableCell)label);
                sheet.setColumnView(i, cellView);
            }
            w.write();
            w.close();
            log.info((Object)"Schemat tabeli dynamicznej utworzony poprawnie. Generowanie zalacznika do pobrania");
            docName = Tools.isNullOrEmpty((String)docName) || ((String)docName).equalsIgnoreCase("undefined") ? "Schemat tabeli dynamicznej.xls" : (String)docName + " - schemat.xls";
            response.setContentType("application/ms-excel");
            response.setContentLength(bos.size());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + (String)docName + "\"");
            byte[] bosArray = bos.toByteArray();
            for (int i = 0; i < bos.size(); ++i) {
                outputStream.write((int)bosArray[i]);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

