/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.dataFileSync.ListConf;
import com.plusmpm.CUF.database.dataFileSync.ListConfManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.Tools;
import java.util.Date;
import org.apache.log4j.Logger;

public class ListConfManagement {
    public static Logger log = Logger.getLogger(ListConfManagement.class);

    public static void AddListConf(String sName, String sColumns, String sColumnsTypes, String sTableName, String sCriteria) {
        log.info((Object)("************************ AddListConf(sName=" + sName + ", sColumns=" + sColumns + ", sColumnsTypes=" + sColumnsTypes + ", sTableName=" + sTableName + ", sCriteria=" + sCriteria + ") *************************"));
        long startTime = new Date().getTime();
        ListConf listConf = null;
        try {
            if (Tools.isNullOrEmpty((String)sName)) {
                throw new CUFException("Nie podano nazwy konfiguracji");
            }
            if (Tools.isNullOrEmpty((String)sTableName)) {
                throw new CUFException("Nie podano nazwy tabeli");
            }
            if (sColumns != null && sColumnsTypes != null) {
                String[] columnTypesSplit;
                String[] columnsSplit = sColumns.split(",");
                if (columnsSplit.length != (columnTypesSplit = sColumnsTypes.split(",")).length) {
                    throw new CUFException("Niezgodnosc ilosci kolumn i typow kolumn");
                }
                sColumns = sColumns.replaceAll(",", ";");
                sColumnsTypes = sColumnsTypes.replaceAll(",", ";");
            }
            if (sCriteria != null) {
                sCriteria = sCriteria.replaceAll(",", ";");
            }
            if ((listConf = ListConfManager.getListConfByName(sName)) != null) {
                throw new CUFException("Konfiguracja o nazwie " + sName + " juz istnieje");
            }
            listConf = new ListConf();
            listConf.setListName(sName);
            listConf.setColumns(sColumns);
            listConf.setColumnsTypes(sColumnsTypes);
            listConf.setTableName(sTableName);
            listConf.setCriteria(sCriteria);
            ListConfManager.save(listConf);
            log.info((Object)("Dodano konfiguracje o nazwie " + sName + " do pobierania danych z pliku"));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego AddListConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void UpdateListConf(String sName, String sColumns, String sColumnsTypes, String sTableName, String sCriteria) {
        log.info((Object)("************************ UpdateListConf(sName=" + sName + ", sColumns=" + sColumns + ", sColumnsTypes=" + sColumnsTypes + ", sTableName=" + sTableName + ", sCriteria=" + sCriteria + ") *************************"));
        long startTime = new Date().getTime();
        ListConf listConf = null;
        try {
            if (Tools.isNullOrEmpty((String)sName)) {
                throw new CUFException("Nie podano nazwy konfiguracji");
            }
            if (Tools.isNullOrEmpty((String)sTableName)) {
                throw new CUFException("Nie podano nazwy tabeli");
            }
            if (sColumns != null && sColumnsTypes != null) {
                String[] columnTypesSplit;
                String[] columnsSplit = sColumns.split(",");
                if (columnsSplit.length != (columnTypesSplit = sColumnsTypes.split(",")).length) {
                    throw new CUFException("Niezgodnosc ilosci kolumn i typow kolumn");
                }
                sColumns = sColumns.replaceAll(",", ";");
                sColumnsTypes = sColumnsTypes.replaceAll(",", ";");
            }
            if (sCriteria != null) {
                sCriteria = sCriteria.replaceAll(",", ";");
            }
            if ((listConf = ListConfManager.getListConfByName(sName)) == null) {
                throw new CUFException("Konfiguracja o nazwie " + sName + " nie istnieje");
            }
            listConf.setColumns(sColumns);
            listConf.setColumnsTypes(sColumnsTypes);
            listConf.setTableName(sTableName);
            listConf.setCriteria(sCriteria);
            ListConfManager.update(listConf);
            log.info((Object)("Uaktualniono konfiguracje o nazwie " + sName + " do pobierania danych z pliku"));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego UpdateListConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void DeleteListConf(String sName) {
        log.info((Object)("************************ DeleteListConf(sName=" + sName + ") *************************"));
        long startTime = new Date().getTime();
        ListConf listConf = null;
        try {
            if (Tools.isNullOrEmpty((String)sName)) {
                throw new CUFException("Nie podano nazwy konfiguracji");
            }
            listConf = ListConfManager.getListConfByName(sName);
            if (listConf == null) {
                throw new CUFException("Konfiguracja o nazwie " + sName + " nie istnieje");
            }
            ListConfManager.delete(listConf);
            log.info((Object)("Usunieto konfiguracje o nazwie " + sName + " do pobierania danych z pliku"));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteListConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    public static void DeleteAllListConfs() {
        log.info((Object)"************************ DeleteAllListConfs() *************************");
        long startTime = new Date().getTime();
        try {
            ListConfManager.deleteAll();
            log.info((Object)"Usunieto wszystkie konfiguracje do pobierania danych z pliku");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteAllListConfs: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

