/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.SharkFunctions;
import com.suncode.cuf.io.office.ExcelWriter;
import com.suncode.cuf.io.office.model.ExcelFormat;
import com.suncode.cuf.io.office.model.ExportSheetDefinition;
import com.suncode.cuf.io.office.model.writer.ValueWriter;
import com.suncode.cuf.io.office.model.writer.ValueWriterResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ExportDTToExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ExportDTToExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            log.info((Object)"************************* ExportTable Servlet ****************************");
            FileOutputStream fileStream = null;
            FileInputStream fileInputStream = null;
            try {
                String mode = request.getParameter("mode");
                String extension = request.getParameter("extension");
                String title = request.getParameter("title");
                if (StringUtils.isEmpty((String)title)) {
                    title = "Eksport tabeli dynamicznej";
                }
                if (StringUtils.isEmpty((String)mode) || mode.equals("write")) {
                    log.info((Object)"Params:");
                    log.info((Object)("Title: " + title));
                    log.info((Object)("Extension: " + extension));
                    Map<String, String> headerMappings = this.readHeaderMappings(request.getParameter("headerMappings"));
                    List<Map<String, Object>> data = this.readData(request.getParameter("data"));
                    Map<String, String> types = this.getVariableTypes(headerMappings.keySet(), request.getParameter("processId"));
                    this.convertDatesToStrings(data, headerMappings, types);
                    ByteArrayOutputStream excelData = this.createOutputExcelData(data, headerMappings, types, extension);
                    File tempDirectory = this.getTempServerDirectory(request);
                    File tempFile = File.createTempFile("excel", "." + extension, tempDirectory);
                    log.info((Object)("Utworzy\u0142em plik tymczasowy: " + tempFile));
                    String path = tempFile.getAbsolutePath();
                    fileStream = new FileOutputStream(tempFile);
                    excelData.writeTo(fileStream);
                    JsonMessage jsonResponse = new JsonMessage();
                    Object[] content = new Object[]{path, extension, this.getFileSize(path), title, this.getChecksum(path)};
                    jsonResponse.setData(content);
                    ObjectMapper mapper = new ObjectMapper();
                    response.getWriter().print(mapper.writeValueAsString((Object)jsonResponse));
                    response.getWriter().close();
                } else {
                    String filename = title + "." + extension;
                    String size = request.getParameter("size");
                    String path = request.getParameter("path");
                    String checksum = request.getParameter("checksum");
                    if (this.checkIfFileExists(path) && !checksum.equals(this.getChecksum(path))) {
                        throw new IllegalArgumentException("Niezgodna suma kontrolna pliku lub plik nie istnieje: " + path);
                    }
                    response.setHeader("Content-Disposition", this.getContentDisposition(filename));
                    response.setContentLength(Integer.valueOf(size).intValue());
                    response.setContentType(this.getContentType(extension));
                    fileInputStream = new FileInputStream(path);
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)servletOutputStream);
                    servletOutputStream.flush();
                    IOUtils.closeQuietly((InputStream)fileInputStream);
                    log.info((Object)("Usuwam plik: " + path));
                    Files.delete(Paths.get(path, new String[0]));
                }
                IOUtils.closeQuietly(fileStream);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                response.sendError(403);
                break block9;
            }
            finally {
                IOUtils.closeQuietly(fileStream);
                IOUtils.closeQuietly(fileInputStream);
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private Long getFileSize(String path) throws IOException {
        return Files.size(Paths.get(path, new String[0]));
    }

    private boolean checkIfFileExists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    private String getChecksum(String path) throws FileNotFoundException, IOException {
        try (FileInputStream stream = new FileInputStream(path);){
            String string = DigestUtils.md2Hex((InputStream)stream);
            return string;
        }
    }

    private ByteArrayOutputStream createOutputExcelData(List<Map<String, Object>> data, Map<String, String> headerMappings, Map<String, String> types, String extension) throws IOException {
        ExportSheetDefinition sheet = new ExportSheetDefinition("Arkusz 1", data);
        sheet.setMappings(headerMappings);
        sheet.setKeysSource(ExportSheetDefinition.KeysSource.MAPPING);
        Map<String, Class<?>> classes = this.convertTypes(types);
        for (String type : types.keySet()) {
            ValueWriter valueWriter = ValueWriterResolver.getInstance().resolve(classes.get(type));
            sheet.setValueWriter(type, valueWriter);
        }
        ExcelWriter writer = new ExcelWriter();
        if (extension.equals("xls")) {
            writer.setFormat(ExcelFormat.XLS);
        } else {
            writer.setFormat(ExcelFormat.XLSX);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.write(sheet, (OutputStream)outputStream);
        return outputStream;
    }

    private File getTempServerDirectory(HttpServletRequest req) {
        return (File)req.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    private void convertDatesToStrings(List<Map<String, Object>> data, Map<String, String> headerMappings, Map<String, String> types) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map<String, Object> map : data) {
            for (String key : headerMappings.keySet()) {
                if (!"date".equals(types.get(key)) || map.get(key) == null) continue;
                Date value = sdf.parse((String)map.get(key));
                map.put(key, value);
            }
        }
    }

    private String getContentDisposition(String filename) {
        String filenameEncoding = URIUtil.encodeAll((String)filename);
        StringBuilder contentDisposition = new StringBuilder();
        contentDisposition.append("attachment;");
        contentDisposition.append(" filename=");
        contentDisposition.append(filenameEncoding);
        contentDisposition.append("; filename*=UTF-8''");
        contentDisposition.append(filenameEncoding);
        return contentDisposition.toString();
    }

    private Map<String, Class<?>> convertTypes(Map<String, String> types) {
        HashMap exTypes = new HashMap();
        for (String key : types.keySet()) {
            if (types.get(key).equals("integer")) {
                exTypes.put(key, Integer.class);
                continue;
            }
            if (types.get(key).equals("float")) {
                exTypes.put(key, Double.class);
                continue;
            }
            if (types.get(key).equals("date")) {
                exTypes.put(key, Date.class);
                continue;
            }
            exTypes.put(key, String.class);
        }
        return exTypes;
    }

    private Map<String, String> getVariableTypes(Iterable<String> keySet, String processId) {
        HashMap<String, String> types = new HashMap<String, String>();
        String processDefId = null;
        try {
            processDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(processId);
        }
        catch (Exception e) {
            return types;
        }
        Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
        WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
        for (String varId : keySet) {
            String type = SharkClientFunctions.getVarTypeForVarId(wp, varId);
            types.put(varId, type);
        }
        return types;
    }

    private List<Map<String, Object>> readData(String sData) throws JsonParseException, JsonMappingException, IOException {
        log.info((Object)("sData: " + sData));
        ObjectMapper om = new ObjectMapper();
        List data = (List)om.readValue(sData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        return data;
    }

    private Map<String, String> readHeaderMappings(String sHeaderMappings) throws JsonParseException, JsonMappingException, IOException {
        log.info((Object)("headerMappings: " + sHeaderMappings));
        ObjectMapper om = new ObjectMapper();
        Map map = (Map)om.readValue(sHeaderMappings, (TypeReference)new TypeReference<Map<String, String>>(){});
        return map;
    }

    private String getContentType(String extension) {
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        return "application/vnd.ms-excel.12";
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.info((Object)("headers: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }
}

